%------------------------------------------------------------------------------
% File     : COM197^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Computing Theory
% Problem  : Koenig's lemma (about infinite trees) 51
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [BH+14] Blanchette et al. (2014), Truly Modular (Co)datatypes
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : koenig__51.p [Bla16]

% Status   : Theorem
% Rating   : 0.67 v8.1.0, 0.75 v7.5.0, 1.00 v7.1.0
% Syntax   : Number of formulae    :  337 ( 144 unt;  73 typ;   0 def)
%            Number of atoms       :  638 ( 344 equ;   4 cnn)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives : 4751 (  73   ~;   9   |;  66   &;4318   @)
%                                         (   0 <=>; 285  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   22 (   8 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :  417 ( 417   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   75 (  71 usr;   5 con; 0-7 aty)
%            Number of variables   : 1311 (  50   ^;1125   !;  59   ?;1311   :)
%                                         (  77  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:38:41.216
%------------------------------------------------------------------------------
%----Could-be-implicit typings (7)
thf(ty_t_TreeFI_OtreeFI,type,
    treeFI: $tType > $tType ).

thf(ty_t_Stream_Ostream,type,
    stream: $tType > $tType ).

thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (66)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Osemilattice__sup,type,
    semilattice_sup: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Fun_Ocomp,type,
    comp: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( B > C ) > ( A > B ) > A > C ) ).

thf(sy_c_Fun_Ofun__upd,type,
    fun_upd: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > A > B > A > B ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_OinfiniteTr,type,
    koenig488553731niteTr: 
      !>[A: $tType] : ( ( treeFI @ A ) > $o ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_OkonigPath,type,
    koenig1103336060igPath: 
      !>[A: $tType] : ( ( treeFI @ A ) > ( stream @ A ) ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_OproperPath,type,
    koenig1755522246erPath: 
      !>[A: $tType] : ( ( stream @ A ) > ( treeFI @ A ) > $o ) ).

thf(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Lattices__Big_Osemilattice__sup__class_OSup__fin,type,
    lattic477160up_fin: 
      !>[A: $tType] : ( ( set @ A ) > A ) ).

thf(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Ocoset,type,
    coset: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_List_Ofold,type,
    fold: 
      !>[A: $tType,B: $tType] : ( ( A > B > B ) > ( list @ A ) > B > B ) ).

thf(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( A > B > B ) > ( list @ A ) > B > B ) ).

thf(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olinorder__class_Oinsort__key,type,
    linorder_insort_key: 
      !>[B: $tType,A: $tType] : ( ( B > A ) > B > ( list @ B ) > ( list @ B ) ) ).

thf(sy_c_List_Olinorder__class_Osorted,type,
    linorder_sorted: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : ( list @ A ) ).

thf(sy_c_List_Olist_Ohd,type,
    hd: 
      !>[A: $tType] : ( ( list @ A ) > A ) ).

thf(sy_c_List_Olist_Olist__all,type,
    list_all: 
      !>[A: $tType] : ( ( A > $o ) > ( list @ A ) > $o ) ).

thf(sy_c_List_Olist_Omap,type,
    map: 
      !>[A: $tType,Aa: $tType] : ( ( A > Aa ) > ( list @ A ) > ( list @ Aa ) ) ).

thf(sy_c_List_Olist_Oset,type,
    set2: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_List_Olist_Otl,type,
    tl: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist__update,type,
    list_update: 
      !>[A: $tType] : ( ( list @ A ) > nat > A > ( list @ A ) ) ).

thf(sy_c_List_Omember,type,
    member: 
      !>[A: $tType] : ( ( list @ A ) > A > $o ) ).

thf(sy_c_List_Oremove1,type,
    remove1: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Orev,type,
    rev: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Ounion,type,
    union: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Oinsert,type,
    insert2: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( ( set @ A ) > A ) ).

thf(sy_c_Stream_Ocycle,type,
    cycle: 
      !>[A: $tType] : ( ( list @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Oflat,type,
    flat: 
      !>[A: $tType] : ( ( stream @ ( list @ A ) ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Osdrop__while,type,
    sdrop_while: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Osfilter,type,
    sfilter: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( list @ A ) > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Osinterleave,type,
    sinterleave: 
      !>[A: $tType] : ( ( stream @ A ) > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Osmap2,type,
    smap2: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( A > B > C ) > ( stream @ A ) > ( stream @ B ) > ( stream @ C ) ) ).

thf(sy_c_Stream_Osmember,type,
    smember: 
      !>[A: $tType] : ( A > ( stream @ A ) > $o ) ).

thf(sy_c_Stream_Ostake,type,
    stake: 
      !>[A: $tType] : ( nat > ( stream @ A ) > ( list @ A ) ) ).

thf(sy_c_Stream_Ostream_OSCons,type,
    sCons: 
      !>[A: $tType] : ( A > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Ostream_Ocase__stream,type,
    case_stream: 
      !>[A: $tType,B: $tType] : ( ( A > ( stream @ A ) > B ) > ( stream @ A ) > B ) ).

thf(sy_c_Stream_Ostream_Ocorec__stream,type,
    corec_stream: 
      !>[C: $tType,A: $tType] : ( ( C > A ) > ( C > $o ) > ( C > ( stream @ A ) ) > ( C > C ) > C > ( stream @ A ) ) ).

thf(sy_c_Stream_Ostream_Opred__stream,type,
    pred_stream: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > $o ) ).

thf(sy_c_Stream_Ostream_Oshd,type,
    shd: 
      !>[A: $tType] : ( ( stream @ A ) > A ) ).

thf(sy_c_Stream_Ostream_Osmap,type,
    smap: 
      !>[A: $tType,Aa: $tType] : ( ( A > Aa ) > ( stream @ A ) > ( stream @ Aa ) ) ).

thf(sy_c_Stream_Ostream_Osset,type,
    sset: 
      !>[A: $tType] : ( ( stream @ A ) > ( set @ A ) ) ).

thf(sy_c_Stream_Ostream_Ostl,type,
    stl: 
      !>[A: $tType] : ( ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Ostream__all,type,
    stream_all: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > $o ) ).

thf(sy_c_Stream_Ostreams,type,
    streams: 
      !>[A: $tType] : ( ( set @ A ) > ( set @ ( stream @ A ) ) ) ).

thf(sy_c_TreeFI_OtreeFI_OTree,type,
    tree: 
      !>[A: $tType] : ( A > ( list @ ( treeFI @ A ) ) > ( treeFI @ A ) ) ).

thf(sy_c_TreeFI_OtreeFI_Ocase__treeFI,type,
    case_treeFI: 
      !>[A: $tType,B: $tType] : ( ( A > ( list @ ( treeFI @ A ) ) > B ) > ( treeFI @ A ) > B ) ).

thf(sy_c_TreeFI_OtreeFI_Olab,type,
    lab: 
      !>[A: $tType] : ( ( treeFI @ A ) > A ) ).

thf(sy_c_TreeFI_OtreeFI_Omap__treeFI,type,
    map_treeFI: 
      !>[A: $tType,Aa: $tType] : ( ( A > Aa ) > ( treeFI @ A ) > ( treeFI @ Aa ) ) ).

thf(sy_c_TreeFI_OtreeFI_Opred__treeFI,type,
    pred_treeFI: 
      !>[A: $tType] : ( ( A > $o ) > ( treeFI @ A ) > $o ) ).

thf(sy_c_TreeFI_OtreeFI_Oset__treeFI,type,
    set_treeFI: 
      !>[A: $tType] : ( ( treeFI @ A ) > ( set @ A ) ) ).

thf(sy_c_TreeFI_OtreeFI_Osub,type,
    sub: 
      !>[A: $tType] : ( ( treeFI @ A ) > ( list @ ( treeFI @ A ) ) ) ).

thf(sy_c_TreeFI_Otrev,type,
    trev: 
      !>[A: $tType] : ( ( treeFI @ A ) > ( treeFI @ A ) ) ).

thf(sy_c_member,type,
    member2: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_as,type,
    as: stream @ a ).

thf(sy_v_phi,type,
    phi: ( stream @ a ) > ( treeFI @ a ) > $o ).

thf(sy_v_tr,type,
    tr: treeFI @ a ).

%----Relevant facts (256)
thf(fact_0__C_K_K_K_C,axiom,
    ! [As: stream @ a,Tr: treeFI @ a] :
      ( ( phi @ As @ Tr )
     => ? [X: treeFI @ a] :
          ( ( member2 @ ( treeFI @ a ) @ X @ ( set2 @ ( treeFI @ a ) @ ( sub @ a @ Tr ) ) )
          & ( ( phi @ ( stl @ a @ As ) @ X )
            | ( koenig1755522246erPath @ a @ ( stl @ a @ As ) @ X ) ) ) ) ).

% "***"
thf(fact_1__C_K_C,axiom,
    phi @ as @ tr ).

% "*"
thf(fact_2_properPath_Ocases,axiom,
    ! [A: $tType,A1: stream @ A,A2: treeFI @ A] :
      ( ( koenig1755522246erPath @ A @ A1 @ A2 )
     => ~ ( ( ( shd @ A @ A1 )
            = ( lab @ A @ A2 ) )
         => ! [Tr2: treeFI @ A] :
              ( ( member2 @ ( treeFI @ A ) @ Tr2 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ A2 ) ) )
             => ~ ( koenig1755522246erPath @ A @ ( stl @ A @ A1 ) @ Tr2 ) ) ) ) ).

% properPath.cases
thf(fact_3_properPath_Osimps,axiom,
    ! [A: $tType] :
      ( ( koenig1755522246erPath @ A )
      = ( ^ [A12: stream @ A,A22: treeFI @ A] :
          ? [As2: stream @ A,Tr3: treeFI @ A,Tr4: treeFI @ A] :
            ( ( A12 = As2 )
            & ( A22 = Tr3 )
            & ( ( shd @ A @ As2 )
              = ( lab @ A @ Tr3 ) )
            & ( member2 @ ( treeFI @ A ) @ Tr4 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr3 ) ) )
            & ( koenig1755522246erPath @ A @ ( stl @ A @ As2 ) @ Tr4 ) ) ) ) ).

% properPath.simps
thf(fact_4_properPath_Ointros,axiom,
    ! [A: $tType,As: stream @ A,Tr: treeFI @ A,Tr5: treeFI @ A] :
      ( ( ( shd @ A @ As )
        = ( lab @ A @ Tr ) )
     => ( ( member2 @ ( treeFI @ A ) @ Tr5 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr ) ) )
       => ( ( koenig1755522246erPath @ A @ ( stl @ A @ As ) @ Tr5 )
         => ( koenig1755522246erPath @ A @ As @ Tr ) ) ) ) ).

% properPath.intros
thf(fact_5_properPath_Ocoinduct,axiom,
    ! [A: $tType,X2: ( stream @ A ) > ( treeFI @ A ) > $o,X3: stream @ A,Xa: treeFI @ A] :
      ( ( X2 @ X3 @ Xa )
     => ( ! [X: stream @ A,Xa2: treeFI @ A] :
            ( ( X2 @ X @ Xa2 )
           => ? [As3: stream @ A,Tr6: treeFI @ A,Tr7: treeFI @ A] :
                ( ( X = As3 )
                & ( Xa2 = Tr6 )
                & ( ( shd @ A @ As3 )
                  = ( lab @ A @ Tr6 ) )
                & ( member2 @ ( treeFI @ A ) @ Tr7 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr6 ) ) )
                & ( ( X2 @ ( stl @ A @ As3 ) @ Tr7 )
                  | ( koenig1755522246erPath @ A @ ( stl @ A @ As3 ) @ Tr7 ) ) ) )
       => ( koenig1755522246erPath @ A @ X3 @ Xa ) ) ) ).

% properPath.coinduct
thf(fact_6__C_K_K_C,axiom,
    ! [As: stream @ a,Tr: treeFI @ a] :
      ( ( phi @ As @ Tr )
     => ( ( shd @ a @ As )
        = ( lab @ a @ Tr ) ) ) ).

% "**"
thf(fact_7_treeFI_Oexpand,axiom,
    ! [A: $tType,TreeFI: treeFI @ A,TreeFI2: treeFI @ A] :
      ( ( ( ( lab @ A @ TreeFI )
          = ( lab @ A @ TreeFI2 ) )
        & ( ( sub @ A @ TreeFI )
          = ( sub @ A @ TreeFI2 ) ) )
     => ( TreeFI = TreeFI2 ) ) ).

% treeFI.expand
thf(fact_8_stream_Oexpand,axiom,
    ! [A: $tType,Stream: stream @ A,Stream2: stream @ A] :
      ( ( ( ( shd @ A @ Stream )
          = ( shd @ A @ Stream2 ) )
        & ( ( stl @ A @ Stream )
          = ( stl @ A @ Stream2 ) ) )
     => ( Stream = Stream2 ) ) ).

% stream.expand
thf(fact_9_stream_Ocoinduct,axiom,
    ! [A: $tType,R: ( stream @ A ) > ( stream @ A ) > $o,Stream: stream @ A,Stream2: stream @ A] :
      ( ( R @ Stream @ Stream2 )
     => ( ! [Stream3: stream @ A,Stream4: stream @ A] :
            ( ( R @ Stream3 @ Stream4 )
           => ( ( ( shd @ A @ Stream3 )
                = ( shd @ A @ Stream4 ) )
              & ( R @ ( stl @ A @ Stream3 ) @ ( stl @ A @ Stream4 ) ) ) )
       => ( Stream = Stream2 ) ) ) ).

% stream.coinduct
thf(fact_10_stream_Ocoinduct__strong,axiom,
    ! [A: $tType,R: ( stream @ A ) > ( stream @ A ) > $o,Stream: stream @ A,Stream2: stream @ A] :
      ( ( R @ Stream @ Stream2 )
     => ( ! [Stream3: stream @ A,Stream4: stream @ A] :
            ( ( R @ Stream3 @ Stream4 )
           => ( ( ( shd @ A @ Stream3 )
                = ( shd @ A @ Stream4 ) )
              & ( ( R @ ( stl @ A @ Stream3 ) @ ( stl @ A @ Stream4 ) )
                | ( ( stl @ A @ Stream3 )
                  = ( stl @ A @ Stream4 ) ) ) ) )
       => ( Stream = Stream2 ) ) ) ).

% stream.coinduct_strong
thf(fact_11_konigPath_Osimps_I1_J,axiom,
    ! [A: $tType,T: treeFI @ A] :
      ( ( shd @ A @ ( koenig1103336060igPath @ A @ T ) )
      = ( lab @ A @ T ) ) ).

% konigPath.simps(1)
thf(fact_12_infiniteTr__sub,axiom,
    ! [A: $tType,Tr: treeFI @ A] :
      ( ( koenig488553731niteTr @ A @ Tr )
     => ? [X: treeFI @ A] :
          ( ( member2 @ ( treeFI @ A ) @ X @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr ) ) )
          & ( koenig488553731niteTr @ A @ X ) ) ) ).

% infiniteTr_sub
thf(fact_13_infiniteTr_Ocases,axiom,
    ! [A: $tType,A3: treeFI @ A] :
      ( ( koenig488553731niteTr @ A @ A3 )
     => ~ ! [Tr2: treeFI @ A] :
            ( ( member2 @ ( treeFI @ A ) @ Tr2 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ A3 ) ) )
           => ~ ( koenig488553731niteTr @ A @ Tr2 ) ) ) ).

% infiniteTr.cases
thf(fact_14_infiniteTr_Osimps,axiom,
    ! [A: $tType] :
      ( ( koenig488553731niteTr @ A )
      = ( ^ [A4: treeFI @ A] :
          ? [Tr4: treeFI @ A,Tr3: treeFI @ A] :
            ( ( A4 = Tr3 )
            & ( member2 @ ( treeFI @ A ) @ Tr4 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr3 ) ) )
            & ( koenig488553731niteTr @ A @ Tr4 ) ) ) ) ).

% infiniteTr.simps
thf(fact_15_infiniteTr__coind,axiom,
    ! [A: $tType,Phi: ( treeFI @ A ) > $o,Tr: treeFI @ A] :
      ( ( Phi @ Tr )
     => ( ! [Tr8: treeFI @ A] :
            ( ( Phi @ Tr8 )
           => ? [X4: treeFI @ A] :
                ( ( member2 @ ( treeFI @ A ) @ X4 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr8 ) ) )
                & ( Phi @ X4 ) ) )
       => ( koenig488553731niteTr @ A @ Tr ) ) ) ).

% infiniteTr_coind
thf(fact_16_infiniteTr_Ointros,axiom,
    ! [A: $tType,Tr5: treeFI @ A,Tr: treeFI @ A] :
      ( ( member2 @ ( treeFI @ A ) @ Tr5 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr ) ) )
     => ( ( koenig488553731niteTr @ A @ Tr5 )
       => ( koenig488553731niteTr @ A @ Tr ) ) ) ).

% infiniteTr.intros
thf(fact_17_infiniteTr_Ocoinduct,axiom,
    ! [A: $tType,X2: ( treeFI @ A ) > $o,X3: treeFI @ A] :
      ( ( X2 @ X3 )
     => ( ! [X: treeFI @ A] :
            ( ( X2 @ X )
           => ? [Tr7: treeFI @ A,Tr6: treeFI @ A] :
                ( ( X = Tr6 )
                & ( member2 @ ( treeFI @ A ) @ Tr7 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr6 ) ) )
                & ( ( X2 @ Tr7 )
                  | ( koenig488553731niteTr @ A @ Tr7 ) ) ) )
       => ( koenig488553731niteTr @ A @ X3 ) ) ) ).

% infiniteTr.coinduct
thf(fact_18_infiniteTr__strong__coind,axiom,
    ! [A: $tType,Phi: ( treeFI @ A ) > $o,Tr: treeFI @ A] :
      ( ( Phi @ Tr )
     => ( ! [Tr8: treeFI @ A] :
            ( ( Phi @ Tr8 )
           => ? [X4: treeFI @ A] :
                ( ( member2 @ ( treeFI @ A ) @ X4 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr8 ) ) )
                & ( ( Phi @ X4 )
                  | ( koenig488553731niteTr @ A @ X4 ) ) ) )
       => ( koenig488553731niteTr @ A @ Tr ) ) ) ).

% infiniteTr_strong_coind
thf(fact_19_treeFI_Ocase__eq__if,axiom,
    ! [B: $tType,A: $tType] :
      ( ( case_treeFI @ A @ B )
      = ( ^ [F: A > ( list @ ( treeFI @ A ) ) > B,TreeFI3: treeFI @ A] : ( F @ ( lab @ A @ TreeFI3 ) @ ( sub @ A @ TreeFI3 ) ) ) ) ).

% treeFI.case_eq_if
thf(fact_20_stream_Ocase__eq__if,axiom,
    ! [B: $tType,A: $tType] :
      ( ( case_stream @ A @ B )
      = ( ^ [F: A > ( stream @ A ) > B,Stream5: stream @ A] : ( F @ ( shd @ A @ Stream5 ) @ ( stl @ A @ Stream5 ) ) ) ) ).

% stream.case_eq_if
thf(fact_21_sdrop__while_Osimps,axiom,
    ! [A: $tType] :
      ( ( sdrop_while @ A )
      = ( ^ [P: A > $o,S: stream @ A] : ( if @ ( stream @ A ) @ ( P @ ( shd @ A @ S ) ) @ ( sdrop_while @ A @ P @ ( stl @ A @ S ) ) @ S ) ) ) ).

% sdrop_while.simps
thf(fact_22_treeFI_Ocollapse,axiom,
    ! [A: $tType,TreeFI: treeFI @ A] :
      ( ( tree @ A @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) )
      = TreeFI ) ).

% treeFI.collapse
thf(fact_23_treeFI_Oset__sel_I2_J,axiom,
    ! [A: $tType,X3: treeFI @ A,A3: treeFI @ A,Xa: A] :
      ( ( member2 @ ( treeFI @ A ) @ X3 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ A3 ) ) )
     => ( ( member2 @ A @ Xa @ ( set_treeFI @ A @ X3 ) )
       => ( member2 @ A @ Xa @ ( set_treeFI @ A @ A3 ) ) ) ) ).

% treeFI.set_sel(2)
thf(fact_24_treeFI_Oexhaust__sel,axiom,
    ! [A: $tType,TreeFI: treeFI @ A] :
      ( TreeFI
      = ( tree @ A @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) ) ) ).

% treeFI.exhaust_sel
thf(fact_25_trev_Osimps_I1_J,axiom,
    ! [A: $tType,T: treeFI @ A] :
      ( ( lab @ A @ ( trev @ A @ T ) )
      = ( lab @ A @ T ) ) ).

% trev.simps(1)
thf(fact_26_stream_Ocollapse,axiom,
    ! [A: $tType,Stream: stream @ A] :
      ( ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) )
      = Stream ) ).

% stream.collapse
thf(fact_27_in__streams,axiom,
    ! [A: $tType,S2: stream @ A,S3: set @ A] :
      ( ( member2 @ ( stream @ A ) @ ( stl @ A @ S2 ) @ ( streams @ A @ S3 ) )
     => ( ( member2 @ A @ ( shd @ A @ S2 ) @ S3 )
       => ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ S3 ) ) ) ) ).

% in_streams
thf(fact_28_streamsE,axiom,
    ! [A: $tType,S2: stream @ A,A5: set @ A] :
      ( ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ A5 ) )
     => ~ ( ( member2 @ A @ ( shd @ A @ S2 ) @ A5 )
         => ~ ( member2 @ ( stream @ A ) @ ( stl @ A @ S2 ) @ ( streams @ A @ A5 ) ) ) ) ).

% streamsE
thf(fact_29_stream_Oinject,axiom,
    ! [A: $tType,X1: A,X22: stream @ A,Y1: A,Y2: stream @ A] :
      ( ( ( sCons @ A @ X1 @ X22 )
        = ( sCons @ A @ Y1 @ Y2 ) )
      = ( ( X1 = Y1 )
        & ( X22 = Y2 ) ) ) ).

% stream.inject
thf(fact_30_treeFI_Oinject,axiom,
    ! [A: $tType,X1: A,X22: list @ ( treeFI @ A ),Y1: A,Y2: list @ ( treeFI @ A )] :
      ( ( ( tree @ A @ X1 @ X22 )
        = ( tree @ A @ Y1 @ Y2 ) )
      = ( ( X1 = Y1 )
        & ( X22 = Y2 ) ) ) ).

% treeFI.inject
thf(fact_31_sdrop__while__SCons,axiom,
    ! [A: $tType,P2: A > $o,A3: A,S2: stream @ A] :
      ( ( ( P2 @ A3 )
       => ( ( sdrop_while @ A @ P2 @ ( sCons @ A @ A3 @ S2 ) )
          = ( sdrop_while @ A @ P2 @ S2 ) ) )
      & ( ~ ( P2 @ A3 )
       => ( ( sdrop_while @ A @ P2 @ ( sCons @ A @ A3 @ S2 ) )
          = ( sCons @ A @ A3 @ S2 ) ) ) ) ).

% sdrop_while_SCons
thf(fact_32_streams_Ocoinduct,axiom,
    ! [A: $tType,X2: ( stream @ A ) > $o,X3: stream @ A,A5: set @ A] :
      ( ( X2 @ X3 )
     => ( ! [X: stream @ A] :
            ( ( X2 @ X )
           => ? [A6: A,S4: stream @ A] :
                ( ( X
                  = ( sCons @ A @ A6 @ S4 ) )
                & ( member2 @ A @ A6 @ A5 )
                & ( ( X2 @ S4 )
                  | ( member2 @ ( stream @ A ) @ S4 @ ( streams @ A @ A5 ) ) ) ) )
       => ( member2 @ ( stream @ A ) @ X3 @ ( streams @ A @ A5 ) ) ) ) ).

% streams.coinduct
thf(fact_33_treeFI_Oexhaust,axiom,
    ! [A: $tType,Y: treeFI @ A] :
      ~ ! [X12: A,X23: list @ ( treeFI @ A )] :
          ( Y
         != ( tree @ A @ X12 @ X23 ) ) ).

% treeFI.exhaust
thf(fact_34_streams__Stream,axiom,
    ! [A: $tType,X3: A,S2: stream @ A,A5: set @ A] :
      ( ( member2 @ ( stream @ A ) @ ( sCons @ A @ X3 @ S2 ) @ ( streams @ A @ A5 ) )
      = ( ( member2 @ A @ X3 @ A5 )
        & ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ A5 ) ) ) ) ).

% streams_Stream
thf(fact_35_stream_Oexhaust,axiom,
    ! [A: $tType,Y: stream @ A] :
      ~ ! [X12: A,X23: stream @ A] :
          ( Y
         != ( sCons @ A @ X12 @ X23 ) ) ).

% stream.exhaust
thf(fact_36_streams_Osimps,axiom,
    ! [A: $tType,A3: stream @ A,A5: set @ A] :
      ( ( member2 @ ( stream @ A ) @ A3 @ ( streams @ A @ A5 ) )
      = ( ? [A4: A,S: stream @ A] :
            ( ( A3
              = ( sCons @ A @ A4 @ S ) )
            & ( member2 @ A @ A4 @ A5 )
            & ( member2 @ ( stream @ A ) @ S @ ( streams @ A @ A5 ) ) ) ) ) ).

% streams.simps
thf(fact_37_streams_Ocases,axiom,
    ! [A: $tType,A3: stream @ A,A5: set @ A] :
      ( ( member2 @ ( stream @ A ) @ A3 @ ( streams @ A @ A5 ) )
     => ~ ! [A7: A,S5: stream @ A] :
            ( ( A3
              = ( sCons @ A @ A7 @ S5 ) )
           => ( ( member2 @ A @ A7 @ A5 )
             => ~ ( member2 @ ( stream @ A ) @ S5 @ ( streams @ A @ A5 ) ) ) ) ) ).

% streams.cases
thf(fact_38_treeFI_Ocase,axiom,
    ! [B: $tType,A: $tType,F2: A > ( list @ ( treeFI @ A ) ) > B,X1: A,X22: list @ ( treeFI @ A )] :
      ( ( case_treeFI @ A @ B @ F2 @ ( tree @ A @ X1 @ X22 ) )
      = ( F2 @ X1 @ X22 ) ) ).

% treeFI.case
thf(fact_39_stream_Ocase,axiom,
    ! [B: $tType,A: $tType,F2: A > ( stream @ A ) > B,X1: A,X22: stream @ A] :
      ( ( case_stream @ A @ B @ F2 @ ( sCons @ A @ X1 @ X22 ) )
      = ( F2 @ X1 @ X22 ) ) ).

% stream.case
thf(fact_40_treeFI_Oset__intros_I1_J,axiom,
    ! [A: $tType,A1: A,A2: list @ ( treeFI @ A )] : ( member2 @ A @ A1 @ ( set_treeFI @ A @ ( tree @ A @ A1 @ A2 ) ) ) ).

% treeFI.set_intros(1)
thf(fact_41_trev__trev,axiom,
    ! [A: $tType,Tr: treeFI @ A] :
      ( ( trev @ A @ ( trev @ A @ Tr ) )
      = Tr ) ).

% trev_trev
thf(fact_42_treeFI_Oset__intros_I2_J,axiom,
    ! [A: $tType,X3: treeFI @ A,A2: list @ ( treeFI @ A ),Xa: A,A1: A] :
      ( ( member2 @ ( treeFI @ A ) @ X3 @ ( set2 @ ( treeFI @ A ) @ A2 ) )
     => ( ( member2 @ A @ Xa @ ( set_treeFI @ A @ X3 ) )
       => ( member2 @ A @ Xa @ ( set_treeFI @ A @ ( tree @ A @ A1 @ A2 ) ) ) ) ) ).

% treeFI.set_intros(2)
thf(fact_43_treeFI_Oset__cases,axiom,
    ! [A: $tType,E: A,A3: treeFI @ A] :
      ( ( member2 @ A @ E @ ( set_treeFI @ A @ A3 ) )
     => ( ! [Z2: list @ ( treeFI @ A )] :
            ( A3
           != ( tree @ A @ E @ Z2 ) )
       => ~ ! [Z1: A,Z2: list @ ( treeFI @ A )] :
              ( ( A3
                = ( tree @ A @ Z1 @ Z2 ) )
             => ! [X: treeFI @ A] :
                  ( ( member2 @ ( treeFI @ A ) @ X @ ( set2 @ ( treeFI @ A ) @ Z2 ) )
                 => ~ ( member2 @ A @ E @ ( set_treeFI @ A @ X ) ) ) ) ) ) ).

% treeFI.set_cases
thf(fact_44_treeFI_Oset__induct,axiom,
    ! [A: $tType,X3: A,A3: treeFI @ A,P2: A > ( treeFI @ A ) > $o] :
      ( ( member2 @ A @ X3 @ ( set_treeFI @ A @ A3 ) )
     => ( ! [Z1: A,Z2: list @ ( treeFI @ A )] : ( P2 @ Z1 @ ( tree @ A @ Z1 @ Z2 ) )
       => ( ! [Z1: A,Z2: list @ ( treeFI @ A ),Xa2: treeFI @ A,Xb: A] :
              ( ( member2 @ ( treeFI @ A ) @ Xa2 @ ( set2 @ ( treeFI @ A ) @ Z2 ) )
             => ( ( member2 @ A @ Xb @ ( set_treeFI @ A @ Xa2 ) )
               => ( ( P2 @ Xb @ Xa2 )
                 => ( P2 @ Xb @ ( tree @ A @ Z1 @ Z2 ) ) ) ) )
         => ( P2 @ X3 @ A3 ) ) ) ) ).

% treeFI.set_induct
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A3: A,P2: A > $o] :
      ( ( member2 @ A @ A3 @ ( collect @ A @ P2 ) )
      = ( P2 @ A3 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( collect @ A
        @ ^ [X5: A] : ( member2 @ A @ X5 @ A5 ) )
      = A5 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P2: A > $o,Q: A > $o] :
      ( ! [X: A] :
          ( ( P2 @ X )
          = ( Q @ X ) )
     => ( ( collect @ A @ P2 )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F2: A > B,G: A > B] :
      ( ! [X: A] :
          ( ( F2 @ X )
          = ( G @ X ) )
     => ( F2 = G ) ) ).

% ext
thf(fact_49_stream_Osel_I2_J,axiom,
    ! [A: $tType,X1: A,X22: stream @ A] :
      ( ( stl @ A @ ( sCons @ A @ X1 @ X22 ) )
      = X22 ) ).

% stream.sel(2)
thf(fact_50_stream_Osel_I1_J,axiom,
    ! [A: $tType,X1: A,X22: stream @ A] :
      ( ( shd @ A @ ( sCons @ A @ X1 @ X22 ) )
      = X1 ) ).

% stream.sel(1)
thf(fact_51_stream_Osplit__sel,axiom,
    ! [B: $tType,A: $tType,P2: B > $o,F2: A > ( stream @ A ) > B,Stream: stream @ A] :
      ( ( P2 @ ( case_stream @ A @ B @ F2 @ Stream ) )
      = ( ( Stream
          = ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) )
       => ( P2 @ ( F2 @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) ) ) ) ).

% stream.split_sel
thf(fact_52_stream_Osplit__sel__asm,axiom,
    ! [B: $tType,A: $tType,P2: B > $o,F2: A > ( stream @ A ) > B,Stream: stream @ A] :
      ( ( P2 @ ( case_stream @ A @ B @ F2 @ Stream ) )
      = ( ~ ( ( Stream
              = ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) )
            & ~ ( P2 @ ( F2 @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) ) ) ) ) ).

% stream.split_sel_asm
thf(fact_53_streams__stl,axiom,
    ! [A: $tType,S2: stream @ A,A5: set @ A] :
      ( ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ A5 ) )
     => ( member2 @ ( stream @ A ) @ ( stl @ A @ S2 ) @ ( streams @ A @ A5 ) ) ) ).

% streams_stl
thf(fact_54_streams__shd,axiom,
    ! [A: $tType,S2: stream @ A,A5: set @ A] :
      ( ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ A5 ) )
     => ( member2 @ A @ ( shd @ A @ S2 ) @ A5 ) ) ).

% streams_shd
thf(fact_55_treeFI_Osel_I2_J,axiom,
    ! [A: $tType,X1: A,X22: list @ ( treeFI @ A )] :
      ( ( sub @ A @ ( tree @ A @ X1 @ X22 ) )
      = X22 ) ).

% treeFI.sel(2)
thf(fact_56_treeFI_Osel_I1_J,axiom,
    ! [A: $tType,X1: A,X22: list @ ( treeFI @ A )] :
      ( ( lab @ A @ ( tree @ A @ X1 @ X22 ) )
      = X1 ) ).

% treeFI.sel(1)
thf(fact_57_treeFI_Oset__sel_I1_J,axiom,
    ! [A: $tType,A3: treeFI @ A] : ( member2 @ A @ ( lab @ A @ A3 ) @ ( set_treeFI @ A @ A3 ) ) ).

% treeFI.set_sel(1)
thf(fact_58_treeFI_Osplit__sel,axiom,
    ! [B: $tType,A: $tType,P2: B > $o,F2: A > ( list @ ( treeFI @ A ) ) > B,TreeFI: treeFI @ A] :
      ( ( P2 @ ( case_treeFI @ A @ B @ F2 @ TreeFI ) )
      = ( ( TreeFI
          = ( tree @ A @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) ) )
       => ( P2 @ ( F2 @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) ) ) ) ) ).

% treeFI.split_sel
thf(fact_59_treeFI_Osplit__sel__asm,axiom,
    ! [B: $tType,A: $tType,P2: B > $o,F2: A > ( list @ ( treeFI @ A ) ) > B,TreeFI: treeFI @ A] :
      ( ( P2 @ ( case_treeFI @ A @ B @ F2 @ TreeFI ) )
      = ( ~ ( ( TreeFI
              = ( tree @ A @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) ) )
            & ~ ( P2 @ ( F2 @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) ) ) ) ) ) ).

% treeFI.split_sel_asm
thf(fact_60_stream_Oexhaust__sel,axiom,
    ! [A: $tType,Stream: stream @ A] :
      ( Stream
      = ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) ) ).

% stream.exhaust_sel
thf(fact_61_smember__code,axiom,
    ! [A: $tType,X3: A,Y: A,S2: stream @ A] :
      ( ( smember @ A @ X3 @ ( sCons @ A @ Y @ S2 ) )
      = ( ( X3 != Y )
       => ( smember @ A @ X3 @ S2 ) ) ) ).

% smember_code
thf(fact_62_sinterleave_Ocode,axiom,
    ! [A: $tType] :
      ( ( sinterleave @ A )
      = ( ^ [S1: stream @ A,S22: stream @ A] : ( sCons @ A @ ( shd @ A @ S1 ) @ ( sinterleave @ A @ S22 @ ( stl @ A @ S1 ) ) ) ) ) ).

% sinterleave.code
thf(fact_63_smap2_Ocode,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( smap2 @ A @ B @ C )
      = ( ^ [F: A > B > C,S1: stream @ A,S22: stream @ B] : ( sCons @ C @ ( F @ ( shd @ A @ S1 ) @ ( shd @ B @ S22 ) ) @ ( smap2 @ A @ B @ C @ F @ ( stl @ A @ S1 ) @ ( stl @ B @ S22 ) ) ) ) ) ).

% smap2.code
thf(fact_64_smap__ctr,axiom,
    ! [B: $tType,A: $tType,F2: B > A,S2: stream @ B,X3: A,S6: stream @ A] :
      ( ( ( smap @ B @ A @ F2 @ S2 )
        = ( sCons @ A @ X3 @ S6 ) )
      = ( ( ( F2 @ ( shd @ B @ S2 ) )
          = X3 )
        & ( ( smap @ B @ A @ F2 @ ( stl @ B @ S2 ) )
          = S6 ) ) ) ).

% smap_ctr
thf(fact_65_sfilter_Ocode,axiom,
    ! [A: $tType] :
      ( ( sfilter @ A )
      = ( ^ [P: A > $o,S: stream @ A] : ( sCons @ A @ ( shd @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P ) @ S ) ) @ ( sfilter @ A @ P @ ( stl @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P ) @ S ) ) ) ) ) ) ).

% sfilter.code
thf(fact_66_stream__all__Stream,axiom,
    ! [A: $tType,P2: A > $o,X3: A,X2: stream @ A] :
      ( ( stream_all @ A @ P2 @ ( sCons @ A @ X3 @ X2 ) )
      = ( ( P2 @ X3 )
        & ( stream_all @ A @ P2 @ X2 ) ) ) ).

% stream_all_Stream
thf(fact_67_stream_Opred__inject,axiom,
    ! [A: $tType,P2: A > $o,A3: A,Aa2: stream @ A] :
      ( ( pred_stream @ A @ P2 @ ( sCons @ A @ A3 @ Aa2 ) )
      = ( ( P2 @ A3 )
        & ( pred_stream @ A @ P2 @ Aa2 ) ) ) ).

% stream.pred_inject
thf(fact_68_sset__induct,axiom,
    ! [A: $tType,Y: A,S2: stream @ A,P2: A > ( stream @ A ) > $o] :
      ( ( member2 @ A @ Y @ ( sset @ A @ S2 ) )
     => ( ! [S5: stream @ A] : ( P2 @ ( shd @ A @ S5 ) @ S5 )
       => ( ! [S5: stream @ A,Y3: A] :
              ( ( member2 @ A @ Y3 @ ( sset @ A @ ( stl @ A @ S5 ) ) )
             => ( ( P2 @ Y3 @ ( stl @ A @ S5 ) )
               => ( P2 @ Y3 @ S5 ) ) )
         => ( P2 @ Y @ S2 ) ) ) ) ).

% sset_induct
thf(fact_69_sfilter__Stream,axiom,
    ! [A: $tType,P2: A > $o,X3: A,S2: stream @ A] :
      ( ( ( P2 @ X3 )
       => ( ( sfilter @ A @ P2 @ ( sCons @ A @ X3 @ S2 ) )
          = ( sCons @ A @ X3 @ ( sfilter @ A @ P2 @ S2 ) ) ) )
      & ( ~ ( P2 @ X3 )
       => ( ( sfilter @ A @ P2 @ ( sCons @ A @ X3 @ S2 ) )
          = ( sfilter @ A @ P2 @ S2 ) ) ) ) ).

% sfilter_Stream
thf(fact_70_stream_Omap__sel_I2_J,axiom,
    ! [B: $tType,A: $tType,F2: A > B,A3: stream @ A] :
      ( ( stl @ B @ ( smap @ A @ B @ F2 @ A3 ) )
      = ( smap @ A @ B @ F2 @ ( stl @ A @ A3 ) ) ) ).

% stream.map_sel(2)
thf(fact_71_stream_Omap__sel_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: A > B,A3: stream @ A] :
      ( ( shd @ B @ ( smap @ A @ B @ F2 @ A3 ) )
      = ( F2 @ ( shd @ A @ A3 ) ) ) ).

% stream.map_sel(1)
thf(fact_72_Stream_Osmember__def,axiom,
    ! [A: $tType] :
      ( ( smember @ A )
      = ( ^ [X5: A,S: stream @ A] : ( member2 @ A @ X5 @ ( sset @ A @ S ) ) ) ) ).

% Stream.smember_def
thf(fact_73_stream_Omap__comp,axiom,
    ! [B: $tType,C: $tType,A: $tType,G: B > C,F2: A > B,V: stream @ A] :
      ( ( smap @ B @ C @ G @ ( smap @ A @ B @ F2 @ V ) )
      = ( smap @ A @ C @ ( comp @ B @ C @ A @ G @ F2 ) @ V ) ) ).

% stream.map_comp
thf(fact_74_stream_Omap__cong,axiom,
    ! [B: $tType,A: $tType,X3: stream @ A,Ya: stream @ A,F2: A > B,G: A > B] :
      ( ( X3 = Ya )
     => ( ! [Z: A] :
            ( ( member2 @ A @ Z @ ( sset @ A @ Ya ) )
           => ( ( F2 @ Z )
              = ( G @ Z ) ) )
       => ( ( smap @ A @ B @ F2 @ X3 )
          = ( smap @ A @ B @ G @ Ya ) ) ) ) ).

% stream.map_cong
thf(fact_75_stream_Opred__map,axiom,
    ! [B: $tType,A: $tType,Q: B > $o,F2: A > B,X3: stream @ A] :
      ( ( pred_stream @ B @ Q @ ( smap @ A @ B @ F2 @ X3 ) )
      = ( pred_stream @ A @ ( comp @ B @ $o @ A @ Q @ F2 ) @ X3 ) ) ).

% stream.pred_map
thf(fact_76_stream_Omap__cong0,axiom,
    ! [B: $tType,A: $tType,X3: stream @ A,F2: A > B,G: A > B] :
      ( ! [Z: A] :
          ( ( member2 @ A @ Z @ ( sset @ A @ X3 ) )
         => ( ( F2 @ Z )
            = ( G @ Z ) ) )
     => ( ( smap @ A @ B @ F2 @ X3 )
        = ( smap @ A @ B @ G @ X3 ) ) ) ).

% stream.map_cong0
thf(fact_77_stream_Opred__cong,axiom,
    ! [A: $tType,X3: stream @ A,Ya: stream @ A,P2: A > $o,Pa: A > $o] :
      ( ( X3 = Ya )
     => ( ! [Z: A] :
            ( ( member2 @ A @ Z @ ( sset @ A @ Ya ) )
           => ( ( P2 @ Z )
              = ( Pa @ Z ) ) )
       => ( ( pred_stream @ A @ P2 @ X3 )
          = ( pred_stream @ A @ Pa @ Ya ) ) ) ) ).

% stream.pred_cong
thf(fact_78_stream_Oinj__map__strong,axiom,
    ! [B: $tType,A: $tType,X3: stream @ A,Xa: stream @ A,F2: A > B,Fa: A > B] :
      ( ! [Z: A,Za: A] :
          ( ( member2 @ A @ Z @ ( sset @ A @ X3 ) )
         => ( ( member2 @ A @ Za @ ( sset @ A @ Xa ) )
           => ( ( ( F2 @ Z )
                = ( Fa @ Za ) )
             => ( Z = Za ) ) ) )
     => ( ( ( smap @ A @ B @ F2 @ X3 )
          = ( smap @ A @ B @ Fa @ Xa ) )
       => ( X3 = Xa ) ) ) ).

% stream.inj_map_strong
thf(fact_79_stream_Opred__mono__strong,axiom,
    ! [A: $tType,P2: A > $o,X3: stream @ A,Pa: A > $o] :
      ( ( pred_stream @ A @ P2 @ X3 )
     => ( ! [Z: A] :
            ( ( member2 @ A @ Z @ ( sset @ A @ X3 ) )
           => ( ( P2 @ Z )
             => ( Pa @ Z ) ) )
       => ( pred_stream @ A @ Pa @ X3 ) ) ) ).

% stream.pred_mono_strong
thf(fact_80_stream_Omap,axiom,
    ! [B: $tType,A: $tType,F2: A > B,X1: A,X22: stream @ A] :
      ( ( smap @ A @ B @ F2 @ ( sCons @ A @ X1 @ X22 ) )
      = ( sCons @ B @ ( F2 @ X1 ) @ ( smap @ A @ B @ F2 @ X22 ) ) ) ).

% stream.map
thf(fact_81_stl__sset,axiom,
    ! [A: $tType,X3: A,A3: stream @ A] :
      ( ( member2 @ A @ X3 @ ( sset @ A @ ( stl @ A @ A3 ) ) )
     => ( member2 @ A @ X3 @ ( sset @ A @ A3 ) ) ) ).

% stl_sset
thf(fact_82_shd__sset,axiom,
    ! [A: $tType,A3: stream @ A] : ( member2 @ A @ ( shd @ A @ A3 ) @ ( sset @ A @ A3 ) ) ).

% shd_sset
thf(fact_83_stream_Oset__intros_I2_J,axiom,
    ! [A: $tType,X3: A,A2: stream @ A,A1: A] :
      ( ( member2 @ A @ X3 @ ( sset @ A @ A2 ) )
     => ( member2 @ A @ X3 @ ( sset @ A @ ( sCons @ A @ A1 @ A2 ) ) ) ) ).

% stream.set_intros(2)
thf(fact_84_stream_Oset__intros_I1_J,axiom,
    ! [A: $tType,A1: A,A2: stream @ A] : ( member2 @ A @ A1 @ ( sset @ A @ ( sCons @ A @ A1 @ A2 ) ) ) ).

% stream.set_intros(1)
thf(fact_85_stream_Oset__cases,axiom,
    ! [A: $tType,E: A,A3: stream @ A] :
      ( ( member2 @ A @ E @ ( sset @ A @ A3 ) )
     => ( ! [Z2: stream @ A] :
            ( A3
           != ( sCons @ A @ E @ Z2 ) )
       => ~ ! [Z1: A,Z2: stream @ A] :
              ( ( A3
                = ( sCons @ A @ Z1 @ Z2 ) )
             => ~ ( member2 @ A @ E @ ( sset @ A @ Z2 ) ) ) ) ) ).

% stream.set_cases
thf(fact_86_stream_Oset__induct,axiom,
    ! [A: $tType,X3: A,A3: stream @ A,P2: A > ( stream @ A ) > $o] :
      ( ( member2 @ A @ X3 @ ( sset @ A @ A3 ) )
     => ( ! [Z1: A,Z2: stream @ A] : ( P2 @ Z1 @ ( sCons @ A @ Z1 @ Z2 ) )
       => ( ! [Z1: A,Z2: stream @ A,Xa2: A] :
              ( ( member2 @ A @ Xa2 @ ( sset @ A @ Z2 ) )
             => ( ( P2 @ Xa2 @ Z2 )
               => ( P2 @ Xa2 @ ( sCons @ A @ Z1 @ Z2 ) ) ) )
         => ( P2 @ X3 @ A3 ) ) ) ) ).

% stream.set_induct
thf(fact_87_smap__streams,axiom,
    ! [A: $tType,B: $tType,S2: stream @ A,A5: set @ A,F2: A > B,B2: set @ B] :
      ( ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ A5 ) )
     => ( ! [X: A] :
            ( ( member2 @ A @ X @ A5 )
           => ( member2 @ B @ ( F2 @ X ) @ B2 ) )
       => ( member2 @ ( stream @ B ) @ ( smap @ A @ B @ F2 @ S2 ) @ ( streams @ B @ B2 ) ) ) ) ).

% smap_streams
thf(fact_88_sfilter_Osimps_I2_J,axiom,
    ! [A: $tType,P2: A > $o,S2: stream @ A] :
      ( ( stl @ A @ ( sfilter @ A @ P2 @ S2 ) )
      = ( sfilter @ A @ P2 @ ( stl @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P2 ) @ S2 ) ) ) ) ).

% sfilter.simps(2)
thf(fact_89_sfilter_Osimps_I1_J,axiom,
    ! [A: $tType,P2: A > $o,S2: stream @ A] :
      ( ( shd @ A @ ( sfilter @ A @ P2 @ S2 ) )
      = ( shd @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P2 ) @ S2 ) ) ) ).

% sfilter.simps(1)
thf(fact_90_smap2_Osimps_I2_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,F2: A > B > C,S12: stream @ A,S23: stream @ B] :
      ( ( stl @ C @ ( smap2 @ A @ B @ C @ F2 @ S12 @ S23 ) )
      = ( smap2 @ A @ B @ C @ F2 @ ( stl @ A @ S12 ) @ ( stl @ B @ S23 ) ) ) ).

% smap2.simps(2)
thf(fact_91_smap2_Osimps_I1_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,F2: A > B > C,S12: stream @ A,S23: stream @ B] :
      ( ( shd @ C @ ( smap2 @ A @ B @ C @ F2 @ S12 @ S23 ) )
      = ( F2 @ ( shd @ A @ S12 ) @ ( shd @ B @ S23 ) ) ) ).

% smap2.simps(1)
thf(fact_92_smap2__unfold,axiom,
    ! [B: $tType,A: $tType,C: $tType,F2: B > C > A,A3: B,S12: stream @ B,B3: C,S23: stream @ C] :
      ( ( smap2 @ B @ C @ A @ F2 @ ( sCons @ B @ A3 @ S12 ) @ ( sCons @ C @ B3 @ S23 ) )
      = ( sCons @ A @ ( F2 @ A3 @ B3 ) @ ( smap2 @ B @ C @ A @ F2 @ S12 @ S23 ) ) ) ).

% smap2_unfold
thf(fact_93_sinterleave_Osimps_I2_J,axiom,
    ! [A: $tType,S12: stream @ A,S23: stream @ A] :
      ( ( stl @ A @ ( sinterleave @ A @ S12 @ S23 ) )
      = ( sinterleave @ A @ S23 @ ( stl @ A @ S12 ) ) ) ).

% sinterleave.simps(2)
thf(fact_94_sinterleave_Osimps_I1_J,axiom,
    ! [A: $tType,S12: stream @ A,S23: stream @ A] :
      ( ( shd @ A @ ( sinterleave @ A @ S12 @ S23 ) )
      = ( shd @ A @ S12 ) ) ).

% sinterleave.simps(1)
thf(fact_95_sinterleave__code,axiom,
    ! [A: $tType,X3: A,S12: stream @ A,S23: stream @ A] :
      ( ( sinterleave @ A @ ( sCons @ A @ X3 @ S12 ) @ S23 )
      = ( sCons @ A @ X3 @ ( sinterleave @ A @ S23 @ S12 ) ) ) ).

% sinterleave_code
thf(fact_96_comp__apply,axiom,
    ! [C: $tType,A: $tType,B: $tType] :
      ( ( comp @ B @ A @ C )
      = ( ^ [F: B > A,G2: C > B,X5: C] : ( F @ ( G2 @ X5 ) ) ) ) ).

% comp_apply
thf(fact_97_stream_Omap__o__corec,axiom,
    ! [A: $tType,B: $tType,C: $tType,F2: A > B,G: C > A,Ga: C > $o,Gb: C > ( stream @ A ),Gc: C > C] :
      ( ( comp @ ( stream @ A ) @ ( stream @ B ) @ C @ ( smap @ A @ B @ F2 ) @ ( corec_stream @ C @ A @ G @ Ga @ Gb @ Gc ) )
      = ( corec_stream @ C @ B @ ( comp @ A @ B @ C @ F2 @ G ) @ Ga @ ( comp @ ( stream @ A ) @ ( stream @ B ) @ C @ ( smap @ A @ B @ F2 ) @ Gb ) @ Gc ) ) ).

% stream.map_o_corec
thf(fact_98_rewriteR__comp__comp2,axiom,
    ! [C: $tType,B: $tType,E2: $tType,D: $tType,A: $tType,G: C > B,H: A > C,R1: D > B,R2: A > D,F2: B > E2,L: D > E2] :
      ( ( ( comp @ C @ B @ A @ G @ H )
        = ( comp @ D @ B @ A @ R1 @ R2 ) )
     => ( ( ( comp @ B @ E2 @ D @ F2 @ R1 )
          = L )
       => ( ( comp @ C @ E2 @ A @ ( comp @ B @ E2 @ C @ F2 @ G ) @ H )
          = ( comp @ D @ E2 @ A @ L @ R2 ) ) ) ) ).

% rewriteR_comp_comp2
thf(fact_99_rewriteL__comp__comp2,axiom,
    ! [A: $tType,C: $tType,B: $tType,D: $tType,E2: $tType,F2: C > B,G: A > C,L1: D > B,L2: A > D,H: E2 > A,R3: E2 > D] :
      ( ( ( comp @ C @ B @ A @ F2 @ G )
        = ( comp @ D @ B @ A @ L1 @ L2 ) )
     => ( ( ( comp @ A @ D @ E2 @ L2 @ H )
          = R3 )
       => ( ( comp @ C @ B @ E2 @ F2 @ ( comp @ A @ C @ E2 @ G @ H ) )
          = ( comp @ D @ B @ E2 @ L1 @ R3 ) ) ) ) ).

% rewriteL_comp_comp2
thf(fact_100_rewriteR__comp__comp,axiom,
    ! [C: $tType,D: $tType,B: $tType,A: $tType,G: C > B,H: A > C,R3: A > B,F2: B > D] :
      ( ( ( comp @ C @ B @ A @ G @ H )
        = R3 )
     => ( ( comp @ C @ D @ A @ ( comp @ B @ D @ C @ F2 @ G ) @ H )
        = ( comp @ B @ D @ A @ F2 @ R3 ) ) ) ).

% rewriteR_comp_comp
thf(fact_101_rewriteL__comp__comp,axiom,
    ! [C: $tType,B: $tType,A: $tType,D: $tType,F2: C > B,G: A > C,L: A > B,H: D > A] :
      ( ( ( comp @ C @ B @ A @ F2 @ G )
        = L )
     => ( ( comp @ C @ B @ D @ F2 @ ( comp @ A @ C @ D @ G @ H ) )
        = ( comp @ A @ B @ D @ L @ H ) ) ) ).

% rewriteL_comp_comp
thf(fact_102_type__copy__map__cong0,axiom,
    ! [B: $tType,D: $tType,E2: $tType,A: $tType,C: $tType,M: B > A,G: C > B,X3: C,N: D > A,H: C > D,F2: A > E2] :
      ( ( ( M @ ( G @ X3 ) )
        = ( N @ ( H @ X3 ) ) )
     => ( ( comp @ B @ E2 @ C @ ( comp @ A @ E2 @ B @ F2 @ M ) @ G @ X3 )
        = ( comp @ D @ E2 @ C @ ( comp @ A @ E2 @ D @ F2 @ N ) @ H @ X3 ) ) ) ).

% type_copy_map_cong0
thf(fact_103_stream_Ocorec__disc,axiom,
    ! [A: $tType,C: $tType] :
      ( ( corec_stream @ C @ A )
      = ( corec_stream @ C @ A ) ) ).

% stream.corec_disc
thf(fact_104_stream_Ocorec__sel_I2_J,axiom,
    ! [A: $tType,C: $tType,Q2: C > $o,A3: C,G1: C > A,G21: C > ( stream @ A ),G22: C > C] :
      ( ( ( Q2 @ A3 )
       => ( ( stl @ A @ ( corec_stream @ C @ A @ G1 @ Q2 @ G21 @ G22 @ A3 ) )
          = ( G21 @ A3 ) ) )
      & ( ~ ( Q2 @ A3 )
       => ( ( stl @ A @ ( corec_stream @ C @ A @ G1 @ Q2 @ G21 @ G22 @ A3 ) )
          = ( corec_stream @ C @ A @ G1 @ Q2 @ G21 @ G22 @ ( G22 @ A3 ) ) ) ) ) ).

% stream.corec_sel(2)
thf(fact_105_stream_Ocorec__sel_I1_J,axiom,
    ! [A: $tType,C: $tType,G1: C > A,Q2: C > $o,G21: C > ( stream @ A ),G22: C > C,A3: C] :
      ( ( shd @ A @ ( corec_stream @ C @ A @ G1 @ Q2 @ G21 @ G22 @ A3 ) )
      = ( G1 @ A3 ) ) ).

% stream.corec_sel(1)
thf(fact_106_stream_Ocorec__code,axiom,
    ! [A: $tType,C: $tType] :
      ( ( corec_stream @ C @ A )
      = ( ^ [G12: C > A,Q22: C > $o,G212: C > ( stream @ A ),G222: C > C,A4: C] : ( sCons @ A @ ( G12 @ A4 ) @ ( if @ ( stream @ A ) @ ( Q22 @ A4 ) @ ( G212 @ A4 ) @ ( corec_stream @ C @ A @ G12 @ Q22 @ G212 @ G222 @ ( G222 @ A4 ) ) ) ) ) ) ).

% stream.corec_code
thf(fact_107_comp__def,axiom,
    ! [A: $tType,C: $tType,B: $tType] :
      ( ( comp @ B @ C @ A )
      = ( ^ [F: B > C,G2: A > B,X5: A] : ( F @ ( G2 @ X5 ) ) ) ) ).

% comp_def
thf(fact_108_comp__assoc,axiom,
    ! [B: $tType,D: $tType,C: $tType,A: $tType,F2: D > B,G: C > D,H: A > C] :
      ( ( comp @ C @ B @ A @ ( comp @ D @ B @ C @ F2 @ G ) @ H )
      = ( comp @ D @ B @ A @ F2 @ ( comp @ C @ D @ A @ G @ H ) ) ) ).

% comp_assoc
thf(fact_109_comp__eq__dest,axiom,
    ! [C: $tType,B: $tType,D: $tType,A: $tType,A3: C > B,B3: A > C,C2: D > B,D2: A > D,V: A] :
      ( ( ( comp @ C @ B @ A @ A3 @ B3 )
        = ( comp @ D @ B @ A @ C2 @ D2 ) )
     => ( ( A3 @ ( B3 @ V ) )
        = ( C2 @ ( D2 @ V ) ) ) ) ).

% comp_eq_dest
thf(fact_110_comp__eq__elim,axiom,
    ! [C: $tType,B: $tType,D: $tType,A: $tType,A3: C > B,B3: A > C,C2: D > B,D2: A > D] :
      ( ( ( comp @ C @ B @ A @ A3 @ B3 )
        = ( comp @ D @ B @ A @ C2 @ D2 ) )
     => ! [V2: A] :
          ( ( A3 @ ( B3 @ V2 ) )
          = ( C2 @ ( D2 @ V2 ) ) ) ) ).

% comp_eq_elim
thf(fact_111_comp__eq__dest__lhs,axiom,
    ! [C: $tType,B: $tType,A: $tType,A3: C > B,B3: A > C,C2: A > B,V: A] :
      ( ( ( comp @ C @ B @ A @ A3 @ B3 )
        = C2 )
     => ( ( A3 @ ( B3 @ V ) )
        = ( C2 @ V ) ) ) ).

% comp_eq_dest_lhs
thf(fact_112_comp__cong,axiom,
    ! [C: $tType,B: $tType,D: $tType,A: $tType,E2: $tType,F2: B > A,G: C > B,X3: C,F3: D > A,G3: E2 > D,X6: E2] :
      ( ( ( F2 @ ( G @ X3 ) )
        = ( F3 @ ( G3 @ X6 ) ) )
     => ( ( comp @ B @ A @ C @ F2 @ G @ X3 )
        = ( comp @ D @ A @ E2 @ F3 @ G3 @ X6 ) ) ) ).

% comp_cong
thf(fact_113_comp__apply__eq,axiom,
    ! [B: $tType,D: $tType,A: $tType,C: $tType,F2: B > A,G: C > B,X3: C,H: D > A,K: C > D] :
      ( ( ( F2 @ ( G @ X3 ) )
        = ( H @ ( K @ X3 ) ) )
     => ( ( comp @ B @ A @ C @ F2 @ G @ X3 )
        = ( comp @ D @ A @ C @ H @ K @ X3 ) ) ) ).

% comp_apply_eq
thf(fact_114_fun_Omap__comp,axiom,
    ! [B: $tType,C: $tType,A: $tType,D: $tType,G: B > C,F2: A > B,V: D > A] :
      ( ( comp @ B @ C @ D @ G @ ( comp @ A @ B @ D @ F2 @ V ) )
      = ( comp @ A @ C @ D @ ( comp @ B @ C @ A @ G @ F2 ) @ V ) ) ).

% fun.map_comp
thf(fact_115_stream__all__iff,axiom,
    ! [A: $tType] :
      ( ( stream_all @ A )
      = ( ^ [P: A > $o,S: stream @ A] :
          ! [X5: A] :
            ( ( member2 @ A @ X5 @ ( sset @ A @ S ) )
           => ( P @ X5 ) ) ) ) ).

% stream_all_iff
thf(fact_116_stream_Oset,axiom,
    ! [A: $tType,X1: A,X22: stream @ A] :
      ( ( sset @ A @ ( sCons @ A @ X1 @ X22 ) )
      = ( insert2 @ A @ X1 @ ( sset @ A @ X22 ) ) ) ).

% stream.set
thf(fact_117_stream_Opred__set,axiom,
    ! [A: $tType] :
      ( ( pred_stream @ A )
      = ( ^ [P: A > $o,X5: stream @ A] :
          ! [Y4: A] :
            ( ( member2 @ A @ Y4 @ ( sset @ A @ X5 ) )
           => ( P @ Y4 ) ) ) ) ).

% stream.pred_set
thf(fact_118_treeFI_Opred__set,axiom,
    ! [A: $tType] :
      ( ( pred_treeFI @ A )
      = ( ^ [P: A > $o,X5: treeFI @ A] :
          ! [Y4: A] :
            ( ( member2 @ A @ Y4 @ ( set_treeFI @ A @ X5 ) )
           => ( P @ Y4 ) ) ) ) ).

% treeFI.pred_set
thf(fact_119_sset__sinterleave,axiom,
    ! [A: $tType,S12: stream @ A,S23: stream @ A] :
      ( ( sset @ A @ ( sinterleave @ A @ S12 @ S23 ) )
      = ( sup_sup @ ( set @ A ) @ ( sset @ A @ S12 ) @ ( sset @ A @ S23 ) ) ) ).

% sset_sinterleave
thf(fact_120_sset__streams,axiom,
    ! [A: $tType,S2: stream @ A,A5: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( sset @ A @ S2 ) @ A5 )
     => ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ A5 ) ) ) ).

% sset_streams
thf(fact_121_streams__sset,axiom,
    ! [A: $tType,S2: stream @ A,A5: set @ A] :
      ( ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ A5 ) )
     => ( ord_less_eq @ ( set @ A ) @ ( sset @ A @ S2 ) @ A5 ) ) ).

% streams_sset
thf(fact_122_streams__mono2,axiom,
    ! [A: $tType,S3: set @ A,T2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ S3 @ T2 )
     => ( ord_less_eq @ ( set @ ( stream @ A ) ) @ ( streams @ A @ S3 ) @ ( streams @ A @ T2 ) ) ) ).

% streams_mono2
thf(fact_123_streams__mono,axiom,
    ! [A: $tType,S2: stream @ A,A5: set @ A,B2: set @ A] :
      ( ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ A5 ) )
     => ( ( ord_less_eq @ ( set @ A ) @ A5 @ B2 )
       => ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ B2 ) ) ) ) ).

% streams_mono
thf(fact_124_treeFI_Opred__mono__strong,axiom,
    ! [A: $tType,P2: A > $o,X3: treeFI @ A,Pa: A > $o] :
      ( ( pred_treeFI @ A @ P2 @ X3 )
     => ( ! [Z: A] :
            ( ( member2 @ A @ Z @ ( set_treeFI @ A @ X3 ) )
           => ( ( P2 @ Z )
             => ( Pa @ Z ) ) )
       => ( pred_treeFI @ A @ Pa @ X3 ) ) ) ).

% treeFI.pred_mono_strong
thf(fact_125_treeFI_Opred__cong,axiom,
    ! [A: $tType,X3: treeFI @ A,Ya: treeFI @ A,P2: A > $o,Pa: A > $o] :
      ( ( X3 = Ya )
     => ( ! [Z: A] :
            ( ( member2 @ A @ Z @ ( set_treeFI @ A @ Ya ) )
           => ( ( P2 @ Z )
              = ( Pa @ Z ) ) )
       => ( ( pred_treeFI @ A @ P2 @ X3 )
          = ( pred_treeFI @ A @ Pa @ Ya ) ) ) ) ).

% treeFI.pred_cong
thf(fact_126_streams__iff__sset,axiom,
    ! [A: $tType,S2: stream @ A,A5: set @ A] :
      ( ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ A5 ) )
      = ( ord_less_eq @ ( set @ A ) @ ( sset @ A @ S2 ) @ A5 ) ) ).

% streams_iff_sset
thf(fact_127_subset__code_I1_J,axiom,
    ! [A: $tType,Xs: list @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ B2 )
      = ( ! [X5: A] :
            ( ( member2 @ A @ X5 @ ( set2 @ A @ Xs ) )
           => ( member2 @ A @ X5 @ B2 ) ) ) ) ).

% subset_code(1)
thf(fact_128_sset__shift,axiom,
    ! [A: $tType,Xs: list @ A,S2: stream @ A] :
      ( ( sset @ A @ ( shift @ A @ Xs @ S2 ) )
      = ( sup_sup @ ( set @ A ) @ ( set2 @ A @ Xs ) @ ( sset @ A @ S2 ) ) ) ).

% sset_shift
thf(fact_129_set__union,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( set2 @ A @ ( union @ A @ Xs @ Ys ) )
      = ( sup_sup @ ( set @ A ) @ ( set2 @ A @ Xs ) @ ( set2 @ A @ Ys ) ) ) ).

% set_union
thf(fact_130_treeFI_Opred__inject,axiom,
    ! [A: $tType,P2: A > $o,A3: A,Aa2: list @ ( treeFI @ A )] :
      ( ( pred_treeFI @ A @ P2 @ ( tree @ A @ A3 @ Aa2 ) )
      = ( ( P2 @ A3 )
        & ( list_all @ ( treeFI @ A ) @ ( pred_treeFI @ A @ P2 ) @ Aa2 ) ) ) ).

% treeFI.pred_inject
thf(fact_131_shift__left__inj,axiom,
    ! [A: $tType,Xs: list @ A,S12: stream @ A,S23: stream @ A] :
      ( ( ( shift @ A @ Xs @ S12 )
        = ( shift @ A @ Xs @ S23 ) )
      = ( S12 = S23 ) ) ).

% shift_left_inj
thf(fact_132_stream__all__shift,axiom,
    ! [A: $tType,P2: A > $o,Xs: list @ A,S2: stream @ A] :
      ( ( stream_all @ A @ P2 @ ( shift @ A @ Xs @ S2 ) )
      = ( ( list_all @ A @ P2 @ Xs )
        & ( stream_all @ A @ P2 @ S2 ) ) ) ).

% stream_all_shift
thf(fact_133_list_Opred__cong,axiom,
    ! [A: $tType,X3: list @ A,Ya: list @ A,P2: A > $o,Pa: A > $o] :
      ( ( X3 = Ya )
     => ( ! [Z: A] :
            ( ( member2 @ A @ Z @ ( set2 @ A @ Ya ) )
           => ( ( P2 @ Z )
              = ( Pa @ Z ) ) )
       => ( ( list_all @ A @ P2 @ X3 )
          = ( list_all @ A @ Pa @ Ya ) ) ) ) ).

% list.pred_cong
thf(fact_134_list_Opred__mono__strong,axiom,
    ! [A: $tType,P2: A > $o,X3: list @ A,Pa: A > $o] :
      ( ( list_all @ A @ P2 @ X3 )
     => ( ! [Z: A] :
            ( ( member2 @ A @ Z @ ( set2 @ A @ X3 ) )
           => ( ( P2 @ Z )
             => ( Pa @ Z ) ) )
       => ( list_all @ A @ Pa @ X3 ) ) ) ).

% list.pred_mono_strong
thf(fact_135_list__all__iff,axiom,
    ! [A: $tType] :
      ( ( list_all @ A )
      = ( ^ [P: A > $o,X5: list @ A] :
          ! [Y4: A] :
            ( ( member2 @ A @ Y4 @ ( set2 @ A @ X5 ) )
           => ( P @ Y4 ) ) ) ) ).

% list_all_iff
thf(fact_136_Ball__set__list__all,axiom,
    ! [A: $tType,Xs: list @ A,P2: A > $o] :
      ( ( ! [X5: A] :
            ( ( member2 @ A @ X5 @ ( set2 @ A @ Xs ) )
           => ( P2 @ X5 ) ) )
      = ( list_all @ A @ P2 @ Xs ) ) ).

% Ball_set_list_all
thf(fact_137_list_Opred__set,axiom,
    ! [A: $tType] :
      ( ( list_all @ A )
      = ( ^ [P: A > $o,X5: list @ A] :
          ! [Y4: A] :
            ( ( member2 @ A @ Y4 @ ( set2 @ A @ X5 ) )
           => ( P @ Y4 ) ) ) ) ).

% list.pred_set
thf(fact_138_List_Oset__insert,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( set2 @ A @ ( insert @ A @ X3 @ Xs ) )
      = ( insert2 @ A @ X3 @ ( set2 @ A @ Xs ) ) ) ).

% List.set_insert
thf(fact_139_subset__code_I2_J,axiom,
    ! [B: $tType,A5: set @ B,Ys: list @ B] :
      ( ( ord_less_eq @ ( set @ B ) @ A5 @ ( coset @ B @ Ys ) )
      = ( ! [X5: B] :
            ( ( member2 @ B @ X5 @ ( set2 @ B @ Ys ) )
           => ~ ( member2 @ B @ X5 @ A5 ) ) ) ) ).

% subset_code(2)
thf(fact_140_in__set__member,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
      = ( member @ A @ Xs @ X3 ) ) ).

% in_set_member
thf(fact_141_union__set__fold,axiom,
    ! [A: $tType,Xs: list @ A,A5: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( set2 @ A @ Xs ) @ A5 )
      = ( fold @ A @ ( set @ A ) @ ( insert2 @ A ) @ Xs @ A5 ) ) ).

% union_set_fold
thf(fact_142_in__set__insert,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X3 @ Xs )
        = Xs ) ) ).

% in_set_insert
thf(fact_143_List_Ofold__cong,axiom,
    ! [B: $tType,A: $tType,A3: A,B3: A,Xs: list @ B,Ys: list @ B,F2: B > A > A,G: B > A > A] :
      ( ( A3 = B3 )
     => ( ( Xs = Ys )
       => ( ! [X: B] :
              ( ( member2 @ B @ X @ ( set2 @ B @ Xs ) )
             => ( ( F2 @ X )
                = ( G @ X ) ) )
         => ( ( fold @ B @ A @ F2 @ Xs @ A3 )
            = ( fold @ B @ A @ G @ Ys @ B3 ) ) ) ) ) ).

% List.fold_cong
thf(fact_144_fold__invariant,axiom,
    ! [A: $tType,B: $tType,Xs: list @ A,Q: A > $o,P2: B > $o,S2: B,F2: A > B > B] :
      ( ! [X: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( Q @ X ) )
     => ( ( P2 @ S2 )
       => ( ! [X: A,S5: B] :
              ( ( Q @ X )
             => ( ( P2 @ S5 )
               => ( P2 @ ( F2 @ X @ S5 ) ) ) )
         => ( P2 @ ( fold @ A @ B @ F2 @ Xs @ S2 ) ) ) ) ) ).

% fold_invariant
thf(fact_145_fold__commute__apply,axiom,
    ! [A: $tType,C: $tType,B: $tType,Xs: list @ A,H: B > C,G: A > B > B,F2: A > C > C,S2: B] :
      ( ! [X: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( ( comp @ B @ C @ B @ H @ ( G @ X ) )
            = ( comp @ C @ C @ B @ ( F2 @ X ) @ H ) ) )
     => ( ( H @ ( fold @ A @ B @ G @ Xs @ S2 ) )
        = ( fold @ A @ C @ F2 @ Xs @ ( H @ S2 ) ) ) ) ).

% fold_commute_apply
thf(fact_146_fold__commute,axiom,
    ! [A: $tType,C: $tType,B: $tType,Xs: list @ A,H: B > C,G: A > B > B,F2: A > C > C] :
      ( ! [X: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( ( comp @ B @ C @ B @ H @ ( G @ X ) )
            = ( comp @ C @ C @ B @ ( F2 @ X ) @ H ) ) )
     => ( ( comp @ B @ C @ B @ H @ ( fold @ A @ B @ G @ Xs ) )
        = ( comp @ C @ C @ B @ ( fold @ A @ C @ F2 @ Xs ) @ H ) ) ) ).

% fold_commute
thf(fact_147_foldr__fold,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,F2: A > B > B] :
      ( ! [X: A,Y3: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( ( member2 @ A @ Y3 @ ( set2 @ A @ Xs ) )
           => ( ( comp @ B @ B @ B @ ( F2 @ Y3 ) @ ( F2 @ X ) )
              = ( comp @ B @ B @ B @ ( F2 @ X ) @ ( F2 @ Y3 ) ) ) ) )
     => ( ( foldr @ A @ B @ F2 @ Xs )
        = ( fold @ A @ B @ F2 @ Xs ) ) ) ).

% foldr_fold
thf(fact_148_fold__remove1__split,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,F2: A > B > B,X3: A] :
      ( ! [X: A,Y3: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( ( member2 @ A @ Y3 @ ( set2 @ A @ Xs ) )
           => ( ( comp @ B @ B @ B @ ( F2 @ X ) @ ( F2 @ Y3 ) )
              = ( comp @ B @ B @ B @ ( F2 @ Y3 ) @ ( F2 @ X ) ) ) ) )
     => ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
       => ( ( fold @ A @ B @ F2 @ Xs )
          = ( comp @ B @ B @ B @ ( fold @ A @ B @ F2 @ ( remove1 @ A @ X3 @ Xs ) ) @ ( F2 @ X3 ) ) ) ) ) ).

% fold_remove1_split
thf(fact_149_subset__code_I3_J,axiom,
    ! [C: $tType] :
      ~ ( ord_less_eq @ ( set @ C ) @ ( coset @ C @ ( nil @ C ) ) @ ( set2 @ C @ ( nil @ C ) ) ) ).

% subset_code(3)
thf(fact_150_set__update__subset__insert,axiom,
    ! [A: $tType,Xs: list @ A,I: nat,X3: A] : ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ ( list_update @ A @ Xs @ I @ X3 ) ) @ ( insert2 @ A @ X3 @ ( set2 @ A @ Xs ) ) ) ).

% set_update_subset_insert
thf(fact_151_in__set__remove1,axiom,
    ! [A: $tType,A3: A,B3: A,Xs: list @ A] :
      ( ( A3 != B3 )
     => ( ( member2 @ A @ A3 @ ( set2 @ A @ ( remove1 @ A @ B3 @ Xs ) ) )
        = ( member2 @ A @ A3 @ ( set2 @ A @ Xs ) ) ) ) ).

% in_set_remove1
thf(fact_152_foldr__cong,axiom,
    ! [B: $tType,A: $tType,A3: A,B3: A,L: list @ B,K: list @ B,F2: B > A > A,G: B > A > A] :
      ( ( A3 = B3 )
     => ( ( L = K )
       => ( ! [A7: A,X: B] :
              ( ( member2 @ B @ X @ ( set2 @ B @ L ) )
             => ( ( F2 @ X @ A7 )
                = ( G @ X @ A7 ) ) )
         => ( ( foldr @ B @ A @ F2 @ L @ A3 )
            = ( foldr @ B @ A @ G @ K @ B3 ) ) ) ) ) ).

% foldr_cong
thf(fact_153_notin__set__remove1,axiom,
    ! [A: $tType,X3: A,Xs: list @ A,Y: A] :
      ( ~ ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
     => ~ ( member2 @ A @ X3 @ ( set2 @ A @ ( remove1 @ A @ Y @ Xs ) ) ) ) ).

% notin_set_remove1
thf(fact_154_remove1__idem,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ~ ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
     => ( ( remove1 @ A @ X3 @ Xs )
        = Xs ) ) ).

% remove1_idem
thf(fact_155_shift_Osimps_I1_J,axiom,
    ! [A: $tType,S2: stream @ A] :
      ( ( shift @ A @ ( nil @ A ) @ S2 )
      = S2 ) ).

% shift.simps(1)
thf(fact_156_set__update__subsetI,axiom,
    ! [A: $tType,Xs: list @ A,A5: set @ A,X3: A,I: nat] :
      ( ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ A5 )
     => ( ( member2 @ A @ X3 @ A5 )
       => ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ ( list_update @ A @ Xs @ I @ X3 ) ) @ A5 ) ) ) ).

% set_update_subsetI
thf(fact_157_set__remove1__subset,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] : ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ ( remove1 @ A @ X3 @ Xs ) ) @ ( set2 @ A @ Xs ) ) ).

% set_remove1_subset
thf(fact_158_sset__cycle,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( sset @ A @ ( cycle @ A @ Xs ) )
        = ( set2 @ A @ Xs ) ) ) ).

% sset_cycle
thf(fact_159_flat__Stream,axiom,
    ! [A: $tType,Xs: list @ A,Ws: stream @ ( list @ A )] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( flat @ A @ ( sCons @ ( list @ A ) @ Xs @ Ws ) )
        = ( shift @ A @ Xs @ ( flat @ A @ Ws ) ) ) ) ).

% flat_Stream
thf(fact_160_shift__simps_I1_J,axiom,
    ! [A: $tType,Xs: list @ A,S2: stream @ A] :
      ( ( ( Xs
          = ( nil @ A ) )
       => ( ( shd @ A @ ( shift @ A @ Xs @ S2 ) )
          = ( shd @ A @ S2 ) ) )
      & ( ( Xs
         != ( nil @ A ) )
       => ( ( shd @ A @ ( shift @ A @ Xs @ S2 ) )
          = ( hd @ A @ Xs ) ) ) ) ).

% shift_simps(1)
thf(fact_161_cycle_Osimps_I1_J,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( shd @ A @ ( cycle @ A @ Xs ) )
      = ( hd @ A @ Xs ) ) ).

% cycle.simps(1)
thf(fact_162_flat_Osimps_I1_J,axiom,
    ! [A: $tType,Ws: stream @ ( list @ A )] :
      ( ( shd @ A @ ( flat @ A @ Ws ) )
      = ( hd @ A @ ( shd @ ( list @ A ) @ Ws ) ) ) ).

% flat.simps(1)
thf(fact_163_list_Oset__sel_I1_J,axiom,
    ! [A: $tType,A3: list @ A] :
      ( ( A3
       != ( nil @ A ) )
     => ( member2 @ A @ ( hd @ A @ A3 ) @ ( set2 @ A @ A3 ) ) ) ).

% list.set_sel(1)
thf(fact_164_hd__in__set,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( member2 @ A @ ( hd @ A @ Xs ) @ ( set2 @ A @ Xs ) ) ) ).

% hd_in_set
thf(fact_165_cycle__decomp,axiom,
    ! [A: $tType,U: list @ A] :
      ( ( U
       != ( nil @ A ) )
     => ( ( cycle @ A @ U )
        = ( shift @ A @ U @ ( cycle @ A @ U ) ) ) ) ).

% cycle_decomp
thf(fact_166_flat__unfold,axiom,
    ! [A: $tType,Ws: stream @ ( list @ A )] :
      ( ( ( shd @ ( list @ A ) @ Ws )
       != ( nil @ A ) )
     => ( ( flat @ A @ Ws )
        = ( shift @ A @ ( shd @ ( list @ A ) @ Ws ) @ ( flat @ A @ ( stl @ ( list @ A ) @ Ws ) ) ) ) ) ).

% flat_unfold
thf(fact_167_flat_Ocode,axiom,
    ! [A: $tType] :
      ( ( flat @ A )
      = ( ^ [Ws2: stream @ ( list @ A )] :
            ( sCons @ A @ ( hd @ A @ ( shd @ ( list @ A ) @ Ws2 ) )
            @ ( flat @ A
              @ ( if @ ( stream @ ( list @ A ) )
                @ ( ( tl @ A @ ( shd @ ( list @ A ) @ Ws2 ) )
                  = ( nil @ A ) )
                @ ( stl @ ( list @ A ) @ Ws2 )
                @ ( sCons @ ( list @ A ) @ ( tl @ A @ ( shd @ ( list @ A ) @ Ws2 ) ) @ ( stl @ ( list @ A ) @ Ws2 ) ) ) ) ) ) ) ).

% flat.code
thf(fact_168_flat__Cons,axiom,
    ! [A: $tType,X3: A,Xs: list @ A,Ws: stream @ ( list @ A )] :
      ( ( flat @ A @ ( sCons @ ( list @ A ) @ ( cons @ A @ X3 @ Xs ) @ Ws ) )
      = ( sCons @ A @ X3
        @ ( flat @ A
          @ ( if @ ( stream @ ( list @ A ) )
            @ ( Xs
              = ( nil @ A ) )
            @ Ws
            @ ( sCons @ ( list @ A ) @ Xs @ Ws ) ) ) ) ) ).

% flat_Cons
thf(fact_169_flat_Osimps_I2_J,axiom,
    ! [A: $tType,Ws: stream @ ( list @ A )] :
      ( ( stl @ A @ ( flat @ A @ Ws ) )
      = ( flat @ A
        @ ( if @ ( stream @ ( list @ A ) )
          @ ( ( tl @ A @ ( shd @ ( list @ A ) @ Ws ) )
            = ( nil @ A ) )
          @ ( stl @ ( list @ A ) @ Ws )
          @ ( sCons @ ( list @ A ) @ ( tl @ A @ ( shd @ ( list @ A ) @ Ws ) ) @ ( stl @ ( list @ A ) @ Ws ) ) ) ) ) ).

% flat.simps(2)
thf(fact_170_list_Osimps_I15_J,axiom,
    ! [A: $tType,X21: A,X222: list @ A] :
      ( ( set2 @ A @ ( cons @ A @ X21 @ X222 ) )
      = ( insert2 @ A @ X21 @ ( set2 @ A @ X222 ) ) ) ).

% list.simps(15)
thf(fact_171_not__in__set__insert,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ~ ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X3 @ Xs )
        = ( cons @ A @ X3 @ Xs ) ) ) ).

% not_in_set_insert
thf(fact_172_shift__simps_I2_J,axiom,
    ! [A: $tType,Xs: list @ A,S2: stream @ A] :
      ( ( ( Xs
          = ( nil @ A ) )
       => ( ( stl @ A @ ( shift @ A @ Xs @ S2 ) )
          = ( stl @ A @ S2 ) ) )
      & ( ( Xs
         != ( nil @ A ) )
       => ( ( stl @ A @ ( shift @ A @ Xs @ S2 ) )
          = ( shift @ A @ ( tl @ A @ Xs ) @ S2 ) ) ) ) ).

% shift_simps(2)
thf(fact_173_list_Oset__cases,axiom,
    ! [A: $tType,E: A,A3: list @ A] :
      ( ( member2 @ A @ E @ ( set2 @ A @ A3 ) )
     => ( ! [Z2: list @ A] :
            ( A3
           != ( cons @ A @ E @ Z2 ) )
       => ~ ! [Z1: A,Z2: list @ A] :
              ( ( A3
                = ( cons @ A @ Z1 @ Z2 ) )
             => ~ ( member2 @ A @ E @ ( set2 @ A @ Z2 ) ) ) ) ) ).

% list.set_cases
thf(fact_174_set__ConsD,axiom,
    ! [A: $tType,Y: A,X3: A,Xs: list @ A] :
      ( ( member2 @ A @ Y @ ( set2 @ A @ ( cons @ A @ X3 @ Xs ) ) )
     => ( ( Y = X3 )
        | ( member2 @ A @ Y @ ( set2 @ A @ Xs ) ) ) ) ).

% set_ConsD
thf(fact_175_list_Oset__intros_I1_J,axiom,
    ! [A: $tType,A1: A,A2: list @ A] : ( member2 @ A @ A1 @ ( set2 @ A @ ( cons @ A @ A1 @ A2 ) ) ) ).

% list.set_intros(1)
thf(fact_176_list_Oset__intros_I2_J,axiom,
    ! [A: $tType,X3: A,A2: list @ A,A1: A] :
      ( ( member2 @ A @ X3 @ ( set2 @ A @ A2 ) )
     => ( member2 @ A @ X3 @ ( set2 @ A @ ( cons @ A @ A1 @ A2 ) ) ) ) ).

% list.set_intros(2)
thf(fact_177_set__subset__Cons,axiom,
    ! [A: $tType,Xs: list @ A,X3: A] : ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ ( set2 @ A @ ( cons @ A @ X3 @ Xs ) ) ) ).

% set_subset_Cons
thf(fact_178_list_Oset__sel_I2_J,axiom,
    ! [A: $tType,A3: list @ A,X3: A] :
      ( ( A3
       != ( nil @ A ) )
     => ( ( member2 @ A @ X3 @ ( set2 @ A @ ( tl @ A @ A3 ) ) )
       => ( member2 @ A @ X3 @ ( set2 @ A @ A3 ) ) ) ) ).

% list.set_sel(2)
thf(fact_179_fold__Cons,axiom,
    ! [B: $tType,A: $tType,F2: A > B > B,X3: A,Xs: list @ A] :
      ( ( fold @ A @ B @ F2 @ ( cons @ A @ X3 @ Xs ) )
      = ( comp @ B @ B @ B @ ( fold @ A @ B @ F2 @ Xs ) @ ( F2 @ X3 ) ) ) ).

% fold_Cons
thf(fact_180_foldr__Cons,axiom,
    ! [B: $tType,A: $tType,F2: A > B > B,X3: A,Xs: list @ A] :
      ( ( foldr @ A @ B @ F2 @ ( cons @ A @ X3 @ Xs ) )
      = ( comp @ B @ B @ B @ ( F2 @ X3 ) @ ( foldr @ A @ B @ F2 @ Xs ) ) ) ).

% foldr_Cons
thf(fact_181_shift_Osimps_I2_J,axiom,
    ! [A: $tType,X3: A,Xs: list @ A,S2: stream @ A] :
      ( ( shift @ A @ ( cons @ A @ X3 @ Xs ) @ S2 )
      = ( sCons @ A @ X3 @ ( shift @ A @ Xs @ S2 ) ) ) ).

% shift.simps(2)
thf(fact_182_List_Oinsert__def,axiom,
    ! [A: $tType] :
      ( ( insert @ A )
      = ( ^ [X5: A,Xs2: list @ A] : ( if @ ( list @ A ) @ ( member2 @ A @ X5 @ ( set2 @ A @ Xs2 ) ) @ Xs2 @ ( cons @ A @ X5 @ Xs2 ) ) ) ) ).

% List.insert_def
thf(fact_183_the__elem__set,axiom,
    ! [A: $tType,X3: A] :
      ( ( the_elem @ A @ ( set2 @ A @ ( cons @ A @ X3 @ ( nil @ A ) ) ) )
      = X3 ) ).

% the_elem_set
thf(fact_184_cycle__rotated,axiom,
    ! [A: $tType,V: list @ A,U: list @ A,S2: stream @ A] :
      ( ( V
       != ( nil @ A ) )
     => ( ( ( cycle @ A @ U )
          = ( shift @ A @ V @ S2 ) )
       => ( ( cycle @ A @ ( append @ A @ ( tl @ A @ U ) @ ( cons @ A @ ( hd @ A @ U ) @ ( nil @ A ) ) ) )
          = ( shift @ A @ ( tl @ A @ V ) @ S2 ) ) ) ) ).

% cycle_rotated
thf(fact_185_cycle_Ocode,axiom,
    ! [A: $tType] :
      ( ( cycle @ A )
      = ( ^ [Xs2: list @ A] : ( sCons @ A @ ( hd @ A @ Xs2 ) @ ( cycle @ A @ ( append @ A @ ( tl @ A @ Xs2 ) @ ( cons @ A @ ( hd @ A @ Xs2 ) @ ( nil @ A ) ) ) ) ) ) ) ).

% cycle.code
thf(fact_186_shift__append,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,S2: stream @ A] :
      ( ( shift @ A @ ( append @ A @ Xs @ Ys ) @ S2 )
      = ( shift @ A @ Xs @ ( shift @ A @ Ys @ S2 ) ) ) ).

% shift_append
thf(fact_187_set__append,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( set2 @ A @ ( append @ A @ Xs @ Ys ) )
      = ( sup_sup @ ( set @ A ) @ ( set2 @ A @ Xs ) @ ( set2 @ A @ Ys ) ) ) ).

% set_append
thf(fact_188_fold__append,axiom,
    ! [A: $tType,B: $tType,F2: B > A > A,Xs: list @ B,Ys: list @ B] :
      ( ( fold @ B @ A @ F2 @ ( append @ B @ Xs @ Ys ) )
      = ( comp @ A @ A @ A @ ( fold @ B @ A @ F2 @ Ys ) @ ( fold @ B @ A @ F2 @ Xs ) ) ) ).

% fold_append
thf(fact_189_split__list,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
     => ? [Ys2: list @ A,Zs: list @ A] :
          ( Xs
          = ( append @ A @ Ys2 @ ( cons @ A @ X3 @ Zs ) ) ) ) ).

% split_list
thf(fact_190_split__list__last,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
     => ? [Ys2: list @ A,Zs: list @ A] :
          ( ( Xs
            = ( append @ A @ Ys2 @ ( cons @ A @ X3 @ Zs ) ) )
          & ~ ( member2 @ A @ X3 @ ( set2 @ A @ Zs ) ) ) ) ).

% split_list_last
thf(fact_191_split__list__prop,axiom,
    ! [A: $tType,Xs: list @ A,P2: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P2 @ X4 ) )
     => ? [Ys2: list @ A,X: A] :
          ( ? [Zs: list @ A] :
              ( Xs
              = ( append @ A @ Ys2 @ ( cons @ A @ X @ Zs ) ) )
          & ( P2 @ X ) ) ) ).

% split_list_prop
thf(fact_192_split__list__first,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
     => ? [Ys2: list @ A,Zs: list @ A] :
          ( ( Xs
            = ( append @ A @ Ys2 @ ( cons @ A @ X3 @ Zs ) ) )
          & ~ ( member2 @ A @ X3 @ ( set2 @ A @ Ys2 ) ) ) ) ).

% split_list_first
thf(fact_193_split__list__propE,axiom,
    ! [A: $tType,Xs: list @ A,P2: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P2 @ X4 ) )
     => ~ ! [Ys2: list @ A,X: A] :
            ( ? [Zs: list @ A] :
                ( Xs
                = ( append @ A @ Ys2 @ ( cons @ A @ X @ Zs ) ) )
           => ~ ( P2 @ X ) ) ) ).

% split_list_propE
thf(fact_194_in__set__conv__decomp,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
      = ( ? [Ys3: list @ A,Zs2: list @ A] :
            ( Xs
            = ( append @ A @ Ys3 @ ( cons @ A @ X3 @ Zs2 ) ) ) ) ) ).

% in_set_conv_decomp
thf(fact_195_split__list__last__prop,axiom,
    ! [A: $tType,Xs: list @ A,P2: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P2 @ X4 ) )
     => ? [Ys2: list @ A,X: A,Zs: list @ A] :
          ( ( Xs
            = ( append @ A @ Ys2 @ ( cons @ A @ X @ Zs ) ) )
          & ( P2 @ X )
          & ! [Xa3: A] :
              ( ( member2 @ A @ Xa3 @ ( set2 @ A @ Zs ) )
             => ~ ( P2 @ Xa3 ) ) ) ) ).

% split_list_last_prop
thf(fact_196_split__list__first__prop,axiom,
    ! [A: $tType,Xs: list @ A,P2: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P2 @ X4 ) )
     => ? [Ys2: list @ A,X: A] :
          ( ? [Zs: list @ A] :
              ( Xs
              = ( append @ A @ Ys2 @ ( cons @ A @ X @ Zs ) ) )
          & ( P2 @ X )
          & ! [Xa3: A] :
              ( ( member2 @ A @ Xa3 @ ( set2 @ A @ Ys2 ) )
             => ~ ( P2 @ Xa3 ) ) ) ) ).

% split_list_first_prop
thf(fact_197_split__list__last__propE,axiom,
    ! [A: $tType,Xs: list @ A,P2: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P2 @ X4 ) )
     => ~ ! [Ys2: list @ A,X: A,Zs: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys2 @ ( cons @ A @ X @ Zs ) ) )
           => ( ( P2 @ X )
             => ~ ! [Xa3: A] :
                    ( ( member2 @ A @ Xa3 @ ( set2 @ A @ Zs ) )
                   => ~ ( P2 @ Xa3 ) ) ) ) ) ).

% split_list_last_propE
thf(fact_198_split__list__first__propE,axiom,
    ! [A: $tType,Xs: list @ A,P2: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P2 @ X4 ) )
     => ~ ! [Ys2: list @ A,X: A] :
            ( ? [Zs: list @ A] :
                ( Xs
                = ( append @ A @ Ys2 @ ( cons @ A @ X @ Zs ) ) )
           => ( ( P2 @ X )
             => ~ ! [Xa3: A] :
                    ( ( member2 @ A @ Xa3 @ ( set2 @ A @ Ys2 ) )
                   => ~ ( P2 @ Xa3 ) ) ) ) ) ).

% split_list_first_propE
thf(fact_199_in__set__conv__decomp__last,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
      = ( ? [Ys3: list @ A,Zs2: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys3 @ ( cons @ A @ X3 @ Zs2 ) ) )
            & ~ ( member2 @ A @ X3 @ ( set2 @ A @ Zs2 ) ) ) ) ) ).

% in_set_conv_decomp_last
thf(fact_200_in__set__conv__decomp__first,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
      = ( ? [Ys3: list @ A,Zs2: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys3 @ ( cons @ A @ X3 @ Zs2 ) ) )
            & ~ ( member2 @ A @ X3 @ ( set2 @ A @ Ys3 ) ) ) ) ) ).

% in_set_conv_decomp_first
thf(fact_201_split__list__last__prop__iff,axiom,
    ! [A: $tType,Xs: list @ A,P2: A > $o] :
      ( ( ? [X5: A] :
            ( ( member2 @ A @ X5 @ ( set2 @ A @ Xs ) )
            & ( P2 @ X5 ) ) )
      = ( ? [Ys3: list @ A,X5: A,Zs2: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys3 @ ( cons @ A @ X5 @ Zs2 ) ) )
            & ( P2 @ X5 )
            & ! [Y4: A] :
                ( ( member2 @ A @ Y4 @ ( set2 @ A @ Zs2 ) )
               => ~ ( P2 @ Y4 ) ) ) ) ) ).

% split_list_last_prop_iff
thf(fact_202_split__list__first__prop__iff,axiom,
    ! [A: $tType,Xs: list @ A,P2: A > $o] :
      ( ( ? [X5: A] :
            ( ( member2 @ A @ X5 @ ( set2 @ A @ Xs ) )
            & ( P2 @ X5 ) ) )
      = ( ? [Ys3: list @ A,X5: A] :
            ( ? [Zs2: list @ A] :
                ( Xs
                = ( append @ A @ Ys3 @ ( cons @ A @ X5 @ Zs2 ) ) )
            & ( P2 @ X5 )
            & ! [Y4: A] :
                ( ( member2 @ A @ Y4 @ ( set2 @ A @ Ys3 ) )
               => ~ ( P2 @ Y4 ) ) ) ) ) ).

% split_list_first_prop_iff
thf(fact_203_remove1__append,axiom,
    ! [A: $tType,X3: A,Xs: list @ A,Ys: list @ A] :
      ( ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
       => ( ( remove1 @ A @ X3 @ ( append @ A @ Xs @ Ys ) )
          = ( append @ A @ ( remove1 @ A @ X3 @ Xs ) @ Ys ) ) )
      & ( ~ ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
       => ( ( remove1 @ A @ X3 @ ( append @ A @ Xs @ Ys ) )
          = ( append @ A @ Xs @ ( remove1 @ A @ X3 @ Ys ) ) ) ) ) ).

% remove1_append
thf(fact_204_cycle__Cons,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( cycle @ A @ ( cons @ A @ X3 @ Xs ) )
      = ( sCons @ A @ X3 @ ( cycle @ A @ ( append @ A @ Xs @ ( cons @ A @ X3 @ ( nil @ A ) ) ) ) ) ) ).

% cycle_Cons
thf(fact_205_cycle_Osimps_I2_J,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( stl @ A @ ( cycle @ A @ Xs ) )
      = ( cycle @ A @ ( append @ A @ ( tl @ A @ Xs ) @ ( cons @ A @ ( hd @ A @ Xs ) @ ( nil @ A ) ) ) ) ) ).

% cycle.simps(2)
thf(fact_206_Sup__fin_Oset__eq__fold,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X3: A,Xs: list @ A] :
          ( ( lattic477160up_fin @ A @ ( set2 @ A @ ( cons @ A @ X3 @ Xs ) ) )
          = ( fold @ A @ A @ ( sup_sup @ A ) @ Xs @ X3 ) ) ) ).

% Sup_fin.set_eq_fold
thf(fact_207_sorted_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A3: list @ A] :
          ( ( linorder_sorted @ A @ A3 )
         => ( ( A3
             != ( nil @ A ) )
           => ~ ! [Xs3: list @ A,X: A] :
                  ( ( A3
                    = ( cons @ A @ X @ Xs3 ) )
                 => ( ! [Xa3: A] :
                        ( ( member2 @ A @ Xa3 @ ( set2 @ A @ Xs3 ) )
                       => ( ord_less_eq @ A @ X @ Xa3 ) )
                   => ~ ( linorder_sorted @ A @ Xs3 ) ) ) ) ) ) ).

% sorted.cases
thf(fact_208_sorted_Osimps,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ( linorder_sorted @ A )
        = ( ^ [A4: list @ A] :
              ( ( A4
                = ( nil @ A ) )
              | ? [Xs2: list @ A,X5: A] :
                  ( ( A4
                    = ( cons @ A @ X5 @ Xs2 ) )
                  & ! [Y4: A] :
                      ( ( member2 @ A @ Y4 @ ( set2 @ A @ Xs2 ) )
                     => ( ord_less_eq @ A @ X5 @ Y4 ) )
                  & ( linorder_sorted @ A @ Xs2 ) ) ) ) ) ) ).

% sorted.simps
thf(fact_209_sorted_OCons,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,X3: A] :
          ( ! [X: A] :
              ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
             => ( ord_less_eq @ A @ X3 @ X ) )
         => ( ( linorder_sorted @ A @ Xs )
           => ( linorder_sorted @ A @ ( cons @ A @ X3 @ Xs ) ) ) ) ) ).

% sorted.Cons
thf(fact_210_sorted__Cons,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Xs: list @ A] :
          ( ( linorder_sorted @ A @ ( cons @ A @ X3 @ Xs ) )
          = ( ( linorder_sorted @ A @ Xs )
            & ! [X5: A] :
                ( ( member2 @ A @ X5 @ ( set2 @ A @ Xs ) )
               => ( ord_less_eq @ A @ X3 @ X5 ) ) ) ) ) ).

% sorted_Cons
thf(fact_211_sorted__append,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,Ys: list @ A] :
          ( ( linorder_sorted @ A @ ( append @ A @ Xs @ Ys ) )
          = ( ( linorder_sorted @ A @ Xs )
            & ( linorder_sorted @ A @ Ys )
            & ! [X5: A] :
                ( ( member2 @ A @ X5 @ ( set2 @ A @ Xs ) )
               => ! [Y4: A] :
                    ( ( member2 @ A @ Y4 @ ( set2 @ A @ Ys ) )
                   => ( ord_less_eq @ A @ X5 @ Y4 ) ) ) ) ) ) ).

% sorted_append
thf(fact_212_sorted_Oinducts,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: list @ A,P2: ( list @ A ) > $o] :
          ( ( linorder_sorted @ A @ X3 )
         => ( ( P2 @ ( nil @ A ) )
           => ( ! [Xs3: list @ A,X: A] :
                  ( ! [Xa3: A] :
                      ( ( member2 @ A @ Xa3 @ ( set2 @ A @ Xs3 ) )
                     => ( ord_less_eq @ A @ X @ Xa3 ) )
                 => ( ( linorder_sorted @ A @ Xs3 )
                   => ( ( P2 @ Xs3 )
                     => ( P2 @ ( cons @ A @ X @ Xs3 ) ) ) ) )
             => ( P2 @ X3 ) ) ) ) ) ).

% sorted.inducts
thf(fact_213_insort__is__Cons,axiom,
    ! [A: $tType,B: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ B,F2: B > A,A3: B] :
          ( ! [X: B] :
              ( ( member2 @ B @ X @ ( set2 @ B @ Xs ) )
             => ( ord_less_eq @ A @ ( F2 @ A3 ) @ ( F2 @ X ) ) )
         => ( ( linorder_insort_key @ B @ A @ F2 @ A3 @ Xs )
            = ( cons @ B @ A3 @ Xs ) ) ) ) ).

% insort_is_Cons
thf(fact_214_fold__rev,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,F2: A > B > B] :
      ( ! [X: A,Y3: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( ( member2 @ A @ Y3 @ ( set2 @ A @ Xs ) )
           => ( ( comp @ B @ B @ B @ ( F2 @ Y3 ) @ ( F2 @ X ) )
              = ( comp @ B @ B @ B @ ( F2 @ X ) @ ( F2 @ Y3 ) ) ) ) )
     => ( ( fold @ A @ B @ F2 @ ( rev @ A @ Xs ) )
        = ( fold @ A @ B @ F2 @ Xs ) ) ) ).

% fold_rev
thf(fact_215_set__rev,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( set2 @ A @ ( rev @ A @ Xs ) )
      = ( set2 @ A @ Xs ) ) ).

% set_rev
thf(fact_216_set__insort__key,axiom,
    ! [A: $tType,B: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [F2: B > A,X3: B,Xs: list @ B] :
          ( ( set2 @ B @ ( linorder_insort_key @ B @ A @ F2 @ X3 @ Xs ) )
          = ( insert2 @ B @ X3 @ ( set2 @ B @ Xs ) ) ) ) ).

% set_insort_key
thf(fact_217_trev_Ocode,axiom,
    ! [A: $tType] :
      ( ( trev @ A )
      = ( ^ [T3: treeFI @ A] : ( tree @ A @ ( lab @ A @ T3 ) @ ( map @ ( treeFI @ A ) @ ( treeFI @ A ) @ ( trev @ A ) @ ( rev @ ( treeFI @ A ) @ ( sub @ A @ T3 ) ) ) ) ) ) ).

% trev.code
thf(fact_218_treeFI_Opred__map,axiom,
    ! [B: $tType,A: $tType,Q: B > $o,F2: A > B,X3: treeFI @ A] :
      ( ( pred_treeFI @ B @ Q @ ( map_treeFI @ A @ B @ F2 @ X3 ) )
      = ( pred_treeFI @ A @ ( comp @ B @ $o @ A @ Q @ F2 ) @ X3 ) ) ).

% treeFI.pred_map
thf(fact_219_map__map,axiom,
    ! [B: $tType,A: $tType,C: $tType,F2: B > A,G: C > B,Xs: list @ C] :
      ( ( map @ B @ A @ F2 @ ( map @ C @ B @ G @ Xs ) )
      = ( map @ C @ A @ ( comp @ B @ A @ C @ F2 @ G ) @ Xs ) ) ).

% map_map
thf(fact_220_List_Omap_Ocomp,axiom,
    ! [C: $tType,B: $tType,A: $tType,F2: B > C,G: A > B] :
      ( ( comp @ ( list @ B ) @ ( list @ C ) @ ( list @ A ) @ ( map @ B @ C @ F2 ) @ ( map @ A @ B @ G ) )
      = ( map @ A @ C @ ( comp @ B @ C @ A @ F2 @ G ) ) ) ).

% List.map.comp
thf(fact_221_map__comp__map,axiom,
    ! [B: $tType,C: $tType,A: $tType,F2: C > B,G: A > C] :
      ( ( comp @ ( list @ C ) @ ( list @ B ) @ ( list @ A ) @ ( map @ C @ B @ F2 ) @ ( map @ A @ C @ G ) )
      = ( map @ A @ B @ ( comp @ C @ B @ A @ F2 @ G ) ) ) ).

% map_comp_map
thf(fact_222_list_Omap__comp,axiom,
    ! [B: $tType,C: $tType,A: $tType,G: B > C,F2: A > B,V: list @ A] :
      ( ( map @ B @ C @ G @ ( map @ A @ B @ F2 @ V ) )
      = ( map @ A @ C @ ( comp @ B @ C @ A @ G @ F2 ) @ V ) ) ).

% list.map_comp
thf(fact_223_List_Omap_Ocompositionality,axiom,
    ! [B: $tType,C: $tType,A: $tType,F2: B > C,G: A > B,List: list @ A] :
      ( ( map @ B @ C @ F2 @ ( map @ A @ B @ G @ List ) )
      = ( map @ A @ C @ ( comp @ B @ C @ A @ F2 @ G ) @ List ) ) ).

% List.map.compositionality
thf(fact_224_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,F2: B > A,Xs: list @ B,G: B > A] :
      ( ( ( map @ B @ A @ F2 @ Xs )
        = ( map @ B @ A @ G @ Xs ) )
      = ( ! [X5: B] :
            ( ( member2 @ B @ X5 @ ( set2 @ B @ Xs ) )
           => ( ( F2 @ X5 )
              = ( G @ X5 ) ) ) ) ) ).

% map_eq_conv
thf(fact_225_smap__shift,axiom,
    ! [A: $tType,B: $tType,F2: B > A,Xs: list @ B,S2: stream @ B] :
      ( ( smap @ B @ A @ F2 @ ( shift @ B @ Xs @ S2 ) )
      = ( shift @ A @ ( map @ B @ A @ F2 @ Xs ) @ ( smap @ B @ A @ F2 @ S2 ) ) ) ).

% smap_shift
thf(fact_226_trev_Osimps_I2_J,axiom,
    ! [A: $tType,T: treeFI @ A] :
      ( ( sub @ A @ ( trev @ A @ T ) )
      = ( map @ ( treeFI @ A ) @ ( treeFI @ A ) @ ( trev @ A ) @ ( rev @ ( treeFI @ A ) @ ( sub @ A @ T ) ) ) ) ).

% trev.simps(2)
thf(fact_227_treeFI_Omap__sel_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: A > B,A3: treeFI @ A] :
      ( ( lab @ B @ ( map_treeFI @ A @ B @ F2 @ A3 ) )
      = ( F2 @ ( lab @ A @ A3 ) ) ) ).

% treeFI.map_sel(1)
thf(fact_228_treeFI_Oinj__map__strong,axiom,
    ! [B: $tType,A: $tType,X3: treeFI @ A,Xa: treeFI @ A,F2: A > B,Fa: A > B] :
      ( ! [Z: A,Za: A] :
          ( ( member2 @ A @ Z @ ( set_treeFI @ A @ X3 ) )
         => ( ( member2 @ A @ Za @ ( set_treeFI @ A @ Xa ) )
           => ( ( ( F2 @ Z )
                = ( Fa @ Za ) )
             => ( Z = Za ) ) ) )
     => ( ( ( map_treeFI @ A @ B @ F2 @ X3 )
          = ( map_treeFI @ A @ B @ Fa @ Xa ) )
       => ( X3 = Xa ) ) ) ).

% treeFI.inj_map_strong
thf(fact_229_treeFI_Omap__cong0,axiom,
    ! [B: $tType,A: $tType,X3: treeFI @ A,F2: A > B,G: A > B] :
      ( ! [Z: A] :
          ( ( member2 @ A @ Z @ ( set_treeFI @ A @ X3 ) )
         => ( ( F2 @ Z )
            = ( G @ Z ) ) )
     => ( ( map_treeFI @ A @ B @ F2 @ X3 )
        = ( map_treeFI @ A @ B @ G @ X3 ) ) ) ).

% treeFI.map_cong0
thf(fact_230_treeFI_Omap__cong,axiom,
    ! [B: $tType,A: $tType,X3: treeFI @ A,Ya: treeFI @ A,F2: A > B,G: A > B] :
      ( ( X3 = Ya )
     => ( ! [Z: A] :
            ( ( member2 @ A @ Z @ ( set_treeFI @ A @ Ya ) )
           => ( ( F2 @ Z )
              = ( G @ Z ) ) )
       => ( ( map_treeFI @ A @ B @ F2 @ X3 )
          = ( map_treeFI @ A @ B @ G @ Ya ) ) ) ) ).

% treeFI.map_cong
thf(fact_231_treeFI_Omap__comp,axiom,
    ! [B: $tType,C: $tType,A: $tType,G: B > C,F2: A > B,V: treeFI @ A] :
      ( ( map_treeFI @ B @ C @ G @ ( map_treeFI @ A @ B @ F2 @ V ) )
      = ( map_treeFI @ A @ C @ ( comp @ B @ C @ A @ G @ F2 ) @ V ) ) ).

% treeFI.map_comp
thf(fact_232_treeFI_Omap,axiom,
    ! [B: $tType,A: $tType,F2: A > B,X1: A,X22: list @ ( treeFI @ A )] :
      ( ( map_treeFI @ A @ B @ F2 @ ( tree @ A @ X1 @ X22 ) )
      = ( tree @ B @ ( F2 @ X1 ) @ ( map @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( map_treeFI @ A @ B @ F2 ) @ X22 ) ) ) ).

% treeFI.map
thf(fact_233_treeFI_Omap__sel_I2_J,axiom,
    ! [B: $tType,A: $tType,F2: A > B,A3: treeFI @ A] :
      ( ( sub @ B @ ( map_treeFI @ A @ B @ F2 @ A3 ) )
      = ( map @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( map_treeFI @ A @ B @ F2 ) @ ( sub @ A @ A3 ) ) ) ).

% treeFI.map_sel(2)
thf(fact_234_list_Oinj__map__strong,axiom,
    ! [B: $tType,A: $tType,X3: list @ A,Xa: list @ A,F2: A > B,Fa: A > B] :
      ( ! [Z: A,Za: A] :
          ( ( member2 @ A @ Z @ ( set2 @ A @ X3 ) )
         => ( ( member2 @ A @ Za @ ( set2 @ A @ Xa ) )
           => ( ( ( F2 @ Z )
                = ( Fa @ Za ) )
             => ( Z = Za ) ) ) )
     => ( ( ( map @ A @ B @ F2 @ X3 )
          = ( map @ A @ B @ Fa @ Xa ) )
       => ( X3 = Xa ) ) ) ).

% list.inj_map_strong
thf(fact_235_list_Omap__cong0,axiom,
    ! [B: $tType,A: $tType,X3: list @ A,F2: A > B,G: A > B] :
      ( ! [Z: A] :
          ( ( member2 @ A @ Z @ ( set2 @ A @ X3 ) )
         => ( ( F2 @ Z )
            = ( G @ Z ) ) )
     => ( ( map @ A @ B @ F2 @ X3 )
        = ( map @ A @ B @ G @ X3 ) ) ) ).

% list.map_cong0
thf(fact_236_list_Omap__cong,axiom,
    ! [B: $tType,A: $tType,X3: list @ A,Ya: list @ A,F2: A > B,G: A > B] :
      ( ( X3 = Ya )
     => ( ! [Z: A] :
            ( ( member2 @ A @ Z @ ( set2 @ A @ Ya ) )
           => ( ( F2 @ Z )
              = ( G @ Z ) ) )
       => ( ( map @ A @ B @ F2 @ X3 )
          = ( map @ A @ B @ G @ Ya ) ) ) ) ).

% list.map_cong
thf(fact_237_ex__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys: list @ B,F2: A > B] :
      ( ( ? [Xs2: list @ A] :
            ( Ys
            = ( map @ A @ B @ F2 @ Xs2 ) ) )
      = ( ! [X5: B] :
            ( ( member2 @ B @ X5 @ ( set2 @ B @ Ys ) )
           => ? [Y4: A] :
                ( X5
                = ( F2 @ Y4 ) ) ) ) ) ).

% ex_map_conv
thf(fact_238_map__cong,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,Ys: list @ A,F2: A > B,G: A > B] :
      ( ( Xs = Ys )
     => ( ! [X: A] :
            ( ( member2 @ A @ X @ ( set2 @ A @ Ys ) )
           => ( ( F2 @ X )
              = ( G @ X ) ) )
       => ( ( map @ A @ B @ F2 @ Xs )
          = ( map @ A @ B @ G @ Ys ) ) ) ) ).

% map_cong
thf(fact_239_map__idI,axiom,
    ! [A: $tType,Xs: list @ A,F2: A > A] :
      ( ! [X: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( ( F2 @ X )
            = X ) )
     => ( ( map @ A @ A @ F2 @ Xs )
        = Xs ) ) ).

% map_idI
thf(fact_240_map__ext,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,F2: A > B,G: A > B] :
      ( ! [X: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( ( F2 @ X )
            = ( G @ X ) ) )
     => ( ( map @ A @ B @ F2 @ Xs )
        = ( map @ A @ B @ G @ Xs ) ) ) ).

% map_ext
thf(fact_241_foldr__map,axiom,
    ! [C: $tType,B: $tType,A: $tType,G: B > A > A,F2: C > B,Xs: list @ C,A3: A] :
      ( ( foldr @ B @ A @ G @ ( map @ C @ B @ F2 @ Xs ) @ A3 )
      = ( foldr @ C @ A @ ( comp @ B @ ( A > A ) @ C @ G @ F2 ) @ Xs @ A3 ) ) ).

% foldr_map
thf(fact_242_fold__map,axiom,
    ! [B: $tType,A: $tType,C: $tType,G: B > A > A,F2: C > B,Xs: list @ C] :
      ( ( fold @ B @ A @ G @ ( map @ C @ B @ F2 @ Xs ) )
      = ( fold @ C @ A @ ( comp @ B @ ( A > A ) @ C @ G @ F2 ) @ Xs ) ) ).

% fold_map
thf(fact_243_list_Opred__map,axiom,
    ! [B: $tType,A: $tType,Q: B > $o,F2: A > B,X3: list @ A] :
      ( ( list_all @ B @ Q @ ( map @ A @ B @ F2 @ X3 ) )
      = ( list_all @ A @ ( comp @ B @ $o @ A @ Q @ F2 ) @ X3 ) ) ).

% list.pred_map
thf(fact_244_stake__smap,axiom,
    ! [A: $tType,B: $tType,N2: nat,F2: B > A,S2: stream @ B] :
      ( ( stake @ A @ N2 @ ( smap @ B @ A @ F2 @ S2 ) )
      = ( map @ B @ A @ F2 @ ( stake @ B @ N2 @ S2 ) ) ) ).

% stake_smap
thf(fact_245_map__fun__upd,axiom,
    ! [B: $tType,A: $tType,Y: A,Xs: list @ A,F2: A > B,V: B] :
      ( ~ ( member2 @ A @ Y @ ( set2 @ A @ Xs ) )
     => ( ( map @ A @ B @ ( fun_upd @ A @ B @ F2 @ Y @ V ) @ Xs )
        = ( map @ A @ B @ F2 @ Xs ) ) ) ).

% map_fun_upd
thf(fact_246_fun__upd__apply,axiom,
    ! [A: $tType,B: $tType] :
      ( ( fun_upd @ B @ A )
      = ( ^ [F: B > A,X5: B,Y4: A,Z3: B] : ( if @ A @ ( Z3 = X5 ) @ Y4 @ ( F @ Z3 ) ) ) ) ).

% fun_upd_apply
thf(fact_247_fun__upd__triv,axiom,
    ! [B: $tType,A: $tType,F2: A > B,X3: A] :
      ( ( fun_upd @ A @ B @ F2 @ X3 @ ( F2 @ X3 ) )
      = F2 ) ).

% fun_upd_triv
thf(fact_248_fun__upd__upd,axiom,
    ! [A: $tType,B: $tType,F2: A > B,X3: A,Y: B,Z4: B] :
      ( ( fun_upd @ A @ B @ ( fun_upd @ A @ B @ F2 @ X3 @ Y ) @ X3 @ Z4 )
      = ( fun_upd @ A @ B @ F2 @ X3 @ Z4 ) ) ).

% fun_upd_upd
thf(fact_249_fun__upd__comp,axiom,
    ! [A: $tType,B: $tType,C: $tType,F2: C > B,G: A > C,X3: A,Y: C] :
      ( ( comp @ C @ B @ A @ F2 @ ( fun_upd @ A @ C @ G @ X3 @ Y ) )
      = ( fun_upd @ A @ B @ ( comp @ C @ B @ A @ F2 @ G ) @ X3 @ ( F2 @ Y ) ) ) ).

% fun_upd_comp
thf(fact_250_fun__upd__idem__iff,axiom,
    ! [A: $tType,B: $tType,F2: A > B,X3: A,Y: B] :
      ( ( ( fun_upd @ A @ B @ F2 @ X3 @ Y )
        = F2 )
      = ( ( F2 @ X3 )
        = Y ) ) ).

% fun_upd_idem_iff
thf(fact_251_fun__upd__twist,axiom,
    ! [A: $tType,B: $tType,A3: A,C2: A,M2: A > B,B3: B,D2: B] :
      ( ( A3 != C2 )
     => ( ( fun_upd @ A @ B @ ( fun_upd @ A @ B @ M2 @ A3 @ B3 ) @ C2 @ D2 )
        = ( fun_upd @ A @ B @ ( fun_upd @ A @ B @ M2 @ C2 @ D2 ) @ A3 @ B3 ) ) ) ).

% fun_upd_twist
thf(fact_252_fun__upd__other,axiom,
    ! [B: $tType,A: $tType,Z4: A,X3: A,F2: A > B,Y: B] :
      ( ( Z4 != X3 )
     => ( ( fun_upd @ A @ B @ F2 @ X3 @ Y @ Z4 )
        = ( F2 @ Z4 ) ) ) ).

% fun_upd_other
thf(fact_253_fun__upd__same,axiom,
    ! [B: $tType,A: $tType,F2: B > A,X3: B,Y: A] :
      ( ( fun_upd @ B @ A @ F2 @ X3 @ Y @ X3 )
      = Y ) ).

% fun_upd_same
thf(fact_254_fun__upd__idem,axiom,
    ! [A: $tType,B: $tType,F2: B > A,X3: B,Y: A] :
      ( ( ( F2 @ X3 )
        = Y )
     => ( ( fun_upd @ B @ A @ F2 @ X3 @ Y )
        = F2 ) ) ).

% fun_upd_idem
thf(fact_255_fun__upd__eqD,axiom,
    ! [A: $tType,B: $tType,F2: A > B,X3: A,Y: B,G: A > B,Z4: B] :
      ( ( ( fun_upd @ A @ B @ F2 @ X3 @ Y )
        = ( fun_upd @ A @ B @ G @ X3 @ Z4 ) )
     => ( Y = Z4 ) ) ).

% fun_upd_eqD

%----Type constructors (4)
thf(tcon_fun___Lattices_Osemilattice__sup,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( semilattice_sup @ A9 @ ( type2 @ A9 ) )
     => ( semilattice_sup @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_Set_Oset___Lattices_Osemilattice__sup_1,axiom,
    ! [A8: $tType] : ( semilattice_sup @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_HOL_Obool___Lattices_Osemilattice__sup_2,axiom,
    semilattice_sup @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P2: $o] :
      ( ( P2 = $true )
      | ( P2 = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X3: A,Y: A] :
      ( ( if @ A @ $false @ X3 @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X3: A,Y: A] :
      ( ( if @ A @ $true @ X3 @ Y )
      = X3 ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    koenig1755522246erPath @ a @ as @ tr ).

%------------------------------------------------------------------------------
